/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.arquillian.test.spi.ExceptionProxy;
import org.jboss.arquillian.test.spi.UnknownException;
import org.jboss.arquillian.test.spi.UnknownObject;
import org.junit.Ignore;
import org.junit.Test;

public class ExceptionProxySerializationTestCase {
    @Test
    @Ignore
    public void shouldBeAbleToDeserialize() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(output);
        try {
            throw new RuntimeException("Test", new UnknownException(null));
        }
        catch (Exception e) {
            ExceptionProxy proxy = ExceptionProxy.createForException((Throwable)e);
            out.writeObject(proxy);
            out.flush();
            ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
            final URLClassLoader cl = new URLClassLoader(new URL[0]){

                @Override
                protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                    if (UnknownException.class.getName().equals(name)) {
                        return null;
                    }
                    if (UnknownObject.class.getName().equals(name)) {
                        throw new NoClassDefFoundError(name);
                    }
                    return super.loadClass(name, resolve);
                }
            };
            Thread.currentThread().setContextClassLoader(cl);
            ObjectInputStream in = new ObjectInputStream(input){

                @Override
                protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
                    return super.resolveProxyClass(interfaces);
                }

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    return Class.forName(desc.getName(), false, cl);
                }

                @Override
                protected Object resolveObject(Object obj) throws IOException {
                    return super.resolveObject(obj);
                }
            };
            ExceptionProxy readProxy = (ExceptionProxy)in.readObject();
            readProxy.createException().printStackTrace();
            return;
        }
    }
}

