/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.spi;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jboss.arquillian.test.spi.CombinedException;
import org.jboss.arquillian.test.spi.TestResult;
import org.junit.Test;

public class TestResultFlattenTest {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    @Test
    public void should_flatten_successful_test_results() throws Exception {
        TestResult p1 = TestResult.passed();
        TestResult p2 = TestResult.passed();
        List<TestResult> testResults = Arrays.asList(p1, p2);
        TestResult result = TestResult.flatten(testResults);
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)TestResult.Status.PASSED);
    }

    @Test
    public void should_combine_descriptions() throws Exception {
        TestResult p1 = TestResult.passed((String)"First test passed");
        TestResult p2 = TestResult.passed((String)"Second test passed");
        List<TestResult> testResults = Arrays.asList(p1, p2);
        TestResult result = TestResult.flatten(testResults);
        Assertions.assertThat((String)result.getDescription()).isEqualTo((Object)String.format("PASSED: 'First test passed'%nPASSED: 'Second test passed'%n", new Object[0]));
    }

    @Test
    public void should_treat_skipped_and_passed_tests_as_passed_overall() throws Exception {
        TestResult passed = TestResult.passed((String)"Test passed");
        TestResult skipped = TestResult.skipped();
        List<TestResult> testResults = Arrays.asList(skipped, passed);
        TestResult result = TestResult.flatten(testResults);
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)TestResult.Status.PASSED);
        Assertions.assertThat((String)result.getDescription()).isEqualTo((Object)String.format("SKIPPED: ''%nPASSED: 'Test passed'%n", new Object[0]));
    }

    @Test
    public void should_combine_skipped_and_passed_tests_descriptions() throws Exception {
        TestResult passed = TestResult.passed((String)"First test passed");
        TestResult skipped = TestResult.skipped((String)"Not implemented yet");
        List<TestResult> testResults = Arrays.asList(skipped, passed);
        TestResult result = TestResult.flatten(testResults);
        Assertions.assertThat((String)result.getDescription()).isEqualTo((Object)String.format("SKIPPED: 'Not implemented yet'%nPASSED: 'First test passed'%n", new Object[0]));
    }

    @Test
    public void should_mark_combined_test_result_as_skipped_if_only_skipped_test_results_are_present() throws Exception {
        TestResult s1 = TestResult.skipped();
        TestResult s2 = TestResult.skipped();
        List<TestResult> testResults = Arrays.asList(s1, s2);
        TestResult result = TestResult.flatten(testResults);
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)TestResult.Status.SKIPPED);
    }

    @Test
    public void should_mark_test_result_as_failed_if_there_is_at_least_one_failure() throws Exception {
        TestResult p1 = TestResult.passed((String)"First test passed");
        TestResult s1 = TestResult.skipped((String)"Not implemented yet");
        TestResult f1 = TestResult.failed((Throwable)new RuntimeException("Exception"));
        List<TestResult> testResults = Arrays.asList(p1, s1, f1);
        TestResult result = TestResult.flatten(testResults);
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)TestResult.Status.FAILED);
    }

    @Test
    public void should_mark_test_result_as_failed_if_there_are_only_failures() throws Exception {
        TestResult e1 = TestResult.failed((Throwable)new RuntimeException("Exception 1"));
        TestResult e2 = TestResult.failed((Throwable)new RuntimeException("Exception 2"));
        List<TestResult> testResults = Arrays.asList(e1, e2);
        TestResult result = TestResult.flatten(testResults);
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)TestResult.Status.FAILED);
    }

    @Test
    public void should_propagate_exception_when_only_one_cause_reported() throws Exception {
        RuntimeException cause = new RuntimeException("Exception 1");
        TestResult f1 = TestResult.failed((Throwable)cause);
        List<TestResult> testResults = Arrays.asList(f1);
        TestResult result = TestResult.flatten(testResults);
        Assertions.assertThat((Throwable)result.getThrowable()).isEqualTo((Object)cause);
    }

    @Test
    public void should_combine_exceptions_for_all_failures() throws Exception {
        RuntimeException ex1 = new RuntimeException("Exception 1");
        TestResult e1 = TestResult.failed((Throwable)ex1);
        RuntimeException ex2 = new RuntimeException("Exception 2");
        TestResult e2 = TestResult.failed((Throwable)ex2);
        List<TestResult> testResults = Arrays.asList(e1, e2);
        TestResult result = TestResult.flatten(testResults);
        Assertions.assertThat((Throwable)result.getThrowable()).isInstanceOf(CombinedException.class);
        Assertions.assertThat((List)((CombinedException)result.getThrowable()).getCauses()).containsExactly((Object[])new Throwable[]{ex1, ex2});
    }

    @Test
    public void should_create_exception_messages_in_order() throws Exception {
        RuntimeException ex1 = new RuntimeException("Exception 1");
        TestResult e1 = TestResult.failed((Throwable)ex1);
        RuntimeException ex2 = new RuntimeException("Exception 2");
        TestResult e2 = TestResult.failed((Throwable)ex2);
        List<TestResult> testResults = Arrays.asList(e2, e1);
        TestResult result = TestResult.flatten(testResults);
        Assertions.assertThat((String)result.getThrowable().getMessage()).isEqualTo((Object)("Exception 1: '[java.lang.RuntimeException] Exception 2'" + LINE_SEPARATOR + "Exception 2: '[java.lang.RuntimeException] Exception 1'" + LINE_SEPARATOR));
    }

    @Test
    public void should_ignore_null_entries_in_the_list_of_test_results() throws Exception {
        TestResult p1 = TestResult.passed((String)"First test passed");
        TestResult f1 = TestResult.failed((Throwable)new RuntimeException("Exception"));
        List<TestResult> testResults = Arrays.asList(p1, null, f1);
        TestResult result = TestResult.flatten(testResults);
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)TestResult.Status.FAILED);
    }

    @Test
    public void should_ignore_null_entry_and_treat_result_as_success() throws Exception {
        TestResult p1 = TestResult.passed((String)"First test passed");
        List<TestResult> testResults = Arrays.asList(p1, null);
        TestResult result = TestResult.flatten(testResults);
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)TestResult.Status.PASSED);
    }
}

