/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.arquillian.test.spi.ExceptionProxy;
import org.jboss.arquillian.test.spi.IBean;
import org.jboss.arquillian.test.spi.IException;
import org.junit.Assert;
import org.junit.Test;

public class ExceptionProxyTestCase {
    public static String MSG = "_TEST_";

    @Test(expected=IllegalArgumentException.class)
    public void shouldProxyIllegalArgumentException() throws Throwable {
        this.proxy(new IllegalArgumentException(MSG));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProxyExtendedIllegalArgumentException() throws Throwable {
        this.proxy(new ExtendedIllegalArgumentException(new Exception(MSG)));
    }

    @Test(expected=UnsatisfiedResolutionException.class)
    public void shouldProxyUnsatisfiedResolutionException() throws Throwable {
        this.proxy(new UnsatisfiedResolutionException(new Exception(MSG)));
    }

    @Test
    public void shouldSerializeNonSerializableExceptions() throws Exception {
        ExceptionProxy proxy = this.serialize(ExceptionProxy.createForException((Throwable)new NonSerializableException()));
        Throwable t = proxy.createException();
        Assert.assertEquals(NonSerializableException.class, t.getClass());
        Assert.assertTrue((String)"NonSerializableException should have a message", (boolean)t.getMessage().contains("UnsupportedOperationException"));
        Assert.assertEquals(UnsupportedOperationException.class, t.getCause().getClass());
        Assert.assertTrue((String)"Verify Proxy message contain root cause of deserialization problem", (boolean)proxy.getSerializationProcessException().getMessage().contains("BufferedInputStream"));
    }

    @Test
    public void shouldSerializeNonDeSerializableExceptions() throws Exception {
        ExceptionProxy proxy = this.serialize(ExceptionProxy.createForException((Throwable)new NonDeserializableExtension("Test")));
        Throwable t = proxy.createException();
        Assert.assertEquals(NonDeserializableExtension.class, t.getClass());
        Assert.assertTrue((String)"The exception should have original message", (boolean)t.getMessage().contains("Test"));
        Assert.assertEquals(UnsupportedOperationException.class, t.getCause().getClass());
        Assert.assertTrue((String)"Verify Proxy message contain root cause of deserialization problem", (boolean)proxy.getSerializationProcessException().getMessage().contains("Could not de-serialize"));
    }

    @Test
    public void shouldRecreateInvocationTargetExceptions() throws Exception {
        ExceptionProxy proxy = this.serialize(ExceptionProxy.createForException((Throwable)new InvocationTargetException(new RuntimeException(new ClassNotFoundException()))));
        Throwable t = proxy.createException();
        Assert.assertEquals(InvocationTargetException.class, t.getClass());
        Assert.assertEquals(RuntimeException.class, t.getCause().getClass());
        Assert.assertEquals(ClassNotFoundException.class, t.getCause().getCause().getClass());
    }

    @Test
    public void handleExceptionClassNotOnClientClasspath() throws Throwable {
        Throwable serverException = this.causeServerException();
        System.out.println("Loaded server exception: " + serverException);
        ExceptionProxy proxy = this.serialize(ExceptionProxy.createForException((Throwable)serverException));
        Throwable t = proxy.createException();
        System.out.println("Client exception from proxy: " + t);
        System.out.println("Client exception trace from proxy:");
        t.printStackTrace();
        Assert.assertEquals(IException.class, t.getClass());
    }

    private Throwable causeServerException() throws Exception {
        File serverOnlyClasses = new File("target/serveronly-classes");
        Assert.assertTrue((String)"target/serveronly-classes should exist", (boolean)serverOnlyClasses.exists());
        URL[] serveronlyCP = new URL[]{serverOnlyClasses.toURL()};
        URLClassLoader classLoader = new URLClassLoader(serveronlyCP, this.getClass().getClassLoader());
        Class<?> exClass = classLoader.loadClass("org.jboss.arquillian.test.spi.serveronly.SomeBean");
        IBean bean = (IBean)exClass.newInstance();
        Exception exception = null;
        try {
            bean.invoke();
        }
        catch (Exception e) {
            exception = e;
        }
        return exception;
    }

    private ExceptionProxy serialize(ExceptionProxy proxy) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(output);
        out.writeObject(proxy);
        out.close();
        byte[] data = output.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        return (ExceptionProxy)in.readObject();
    }

    private void proxy(Throwable throwable) throws Throwable {
        throw ExceptionProxy.createForException((Throwable)throwable).createException();
    }

    private void printConstructors(Throwable throwable) throws Exception {
        System.out.println("Declared-Constructors for: " + throwable.getClass());
        for (Constructor<?> constructor : throwable.getClass().getDeclaredConstructors()) {
            System.out.println(constructor);
        }
    }

    private static class ExtendedIllegalArgumentException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        ExtendedIllegalArgumentException(Exception throwable) {
            super(throwable);
        }
    }

    public static class UnsatisfiedResolutionException
    extends ResolutionException {
        private static final long serialVersionUID = 5350603312442756709L;

        public UnsatisfiedResolutionException() {
        }

        public UnsatisfiedResolutionException(String message, Throwable throwable) {
            super(message, throwable);
        }

        public UnsatisfiedResolutionException(String message) {
            super(message);
        }

        public UnsatisfiedResolutionException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class NonSerializableException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private InputStream input = System.in;

        public NonSerializableException() {
            super(new UnsupportedOperationException());
        }
    }

    public static class NonDeserializableExtension
    extends RuntimeException
    implements Externalizable {
        public NonDeserializableExtension() {
        }

        public NonDeserializableExtension(String message) {
            super(message, new UnsupportedOperationException());
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeChars(this.getMessage());
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            throw new RuntimeException("Could not de-serialize");
        }
    }

    public static class InjectionException
    extends RuntimeException {
        private static final long serialVersionUID = -2132733164534544788L;

        public InjectionException() {
        }

        public InjectionException(String message, Throwable throwable) {
            super(message, throwable);
        }

        public InjectionException(String message) {
            super(message);
        }

        public InjectionException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class ResolutionException
    extends InjectionException {
        private static final long serialVersionUID = -6280627846071966243L;

        public ResolutionException() {
        }

        public ResolutionException(String message, Throwable cause) {
            super(message, cause);
        }

        public ResolutionException(String message) {
            super(message);
        }

        public ResolutionException(Throwable cause) {
            super(cause);
        }
    }
}

