/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.cdi;

import java.io.BufferedInputStream;
import java.util.ArrayList;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.testenricher.cdi.client.BeansXMLProtocolProcessor;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;

public class BeansXMLProtocolProcessorTestCase {
    @Test
    public void shouldAddBeansXMLWhenFoundInWebArchive() {
        WebArchive deployment = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        this.runAndAssertWebArchiveProtocol((Archive<?>)deployment, true);
    }

    @Test
    public void shouldAddBeansXMLWhenFoundInJavaArchive() {
        JavaArchive deployment = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        this.runAndAssertJavaArchiveProtocol((Archive<?>)deployment, true);
    }

    @Test
    public void shouldNotAddBeansXMLIfNotFoundInWebArchive() {
        WebArchive deployment = (WebArchive)ShrinkWrap.create(WebArchive.class);
        this.runAndAssertWebArchiveProtocol((Archive<?>)deployment, false);
    }

    @Test
    public void shouldAddBeansXMLWhenFoundInEnterpriseModule() {
        EnterpriseArchive deployment = (EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class)).addAsModule(((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml"));
        this.runAndAssertWebArchiveProtocol((Archive<?>)deployment, true);
    }

    @Test
    public void shouldNotAddBeansXMLIfNotFoundInEnterpriseModule() {
        EnterpriseArchive deployment = (EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class)).addAsModule((Archive)ShrinkWrap.create(WebArchive.class));
        this.runAndAssertWebArchiveProtocol((Archive<?>)deployment, false);
    }

    @Test
    public void shouldNotAddBeansXMLIfArchivesAreEqual() {
        WebArchive protocol = (WebArchive)ShrinkWrap.create(WebArchive.class);
        new BeansXMLProtocolProcessor().process(new TestDeployment((Archive)protocol, new ArrayList()), (Archive)protocol);
        Assert.assertFalse((boolean)protocol.contains("WEB-INF/beans.xml"));
    }

    @Test
    public void shouldNotOverwriteBeansXMLIfArchivesAreTheSameAndContainBeansXml() throws Exception {
        String beansXmlContent = "test";
        WebArchive deployment = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)new StringAsset(beansXmlContent), "beans.xml");
        WebArchive protocol = (WebArchive)deployment.as(WebArchive.class);
        new BeansXMLProtocolProcessor().process(new TestDeployment((Archive)deployment, new ArrayList()), (Archive)protocol);
        Assert.assertTrue((boolean)protocol.contains("WEB-INF/beans.xml"));
        byte[] buf = new byte[beansXmlContent.length()];
        new BufferedInputStream(protocol.get("WEB-INF/beans.xml").getAsset().openStream()).read(buf);
        Assert.assertEquals((Object)beansXmlContent, (Object)new String(buf));
    }

    @Test
    public void shouldNotOverwriteBeansXMLIfProtocolWebArchiveContainBeansXml() throws Exception {
        String beansXmlContent = "test";
        WebArchive deployment = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        WebArchive protocol = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)new StringAsset(beansXmlContent), "beans.xml");
        new BeansXMLProtocolProcessor().process(new TestDeployment((Archive)deployment, new ArrayList()), (Archive)protocol);
        Assert.assertTrue((boolean)protocol.contains("WEB-INF/beans.xml"));
        byte[] buf = new byte[beansXmlContent.length()];
        new BufferedInputStream(protocol.get("WEB-INF/beans.xml").getAsset().openStream()).read(buf);
        Assert.assertEquals((Object)beansXmlContent, (Object)new String(buf));
    }

    @Test
    public void shouldNotOverwriteBeansXMLIfProtocolJavaArchiveContainBeansXml() throws Exception {
        String beansXmlContent = "test";
        JavaArchive deployment = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        JavaArchive protocol = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsManifestResource((Asset)new StringAsset(beansXmlContent), "beans.xml");
        new BeansXMLProtocolProcessor().process(new TestDeployment((Archive)deployment, new ArrayList()), (Archive)protocol);
        Assert.assertTrue((boolean)protocol.contains("META-INF/beans.xml"));
        byte[] buf = new byte[beansXmlContent.length()];
        new BufferedInputStream(protocol.get("META-INF/beans.xml").getAsset().openStream()).read(buf);
        Assert.assertEquals((Object)beansXmlContent, (Object)new String(buf));
    }

    public void runAndAssertWebArchiveProtocol(Archive<?> deployment, boolean shouldBeFound) {
        this.runAndAsset(deployment, (Archive)ShrinkWrap.create(WebArchive.class), shouldBeFound, "WEB-INF/beans.xml");
    }

    public void runAndAssertJavaArchiveProtocol(Archive<?> deployment, boolean shouldBeFound) {
        this.runAndAsset(deployment, (Archive)ShrinkWrap.create(JavaArchive.class), shouldBeFound, "META-INF/beans.xml");
    }

    public void runAndAsset(Archive<?> deployment, Archive<?> protocol, boolean shouldBeFound, String expectedLocation) {
        new BeansXMLProtocolProcessor().process(new TestDeployment(deployment, new ArrayList()), protocol);
        System.out.println(protocol.toString(true));
        Assert.assertEquals((String)("Verify beans.xml was " + (!shouldBeFound ? "not " : "") + "found in " + expectedLocation), (Object)shouldBeFound, (Object)protocol.contains(expectedLocation));
    }
}

