/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.cdi;

import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.test.spi.annotation.TestScoped;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.test.AbstractTestTestBase;
import org.jboss.arquillian.testenricher.cdi.CDIInjectionEnricher;
import org.jboss.arquillian.testenricher.cdi.CreationalContextDestroyer;
import org.jboss.arquillian.testenricher.cdi.beans.Cat;
import org.jboss.arquillian.testenricher.cdi.beans.CatService;
import org.jboss.arquillian.testenricher.cdi.beans.Dog;
import org.jboss.arquillian.testenricher.cdi.beans.DogService;
import org.jboss.arquillian.testenricher.cdi.beans.Service;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class CDIInjectionEnricherTestCase
extends AbstractTestTestBase {
    private SeContainer container;
    private BeanManager manager;
    private CDIInjectionEnricher enricher;
    @org.jboss.arquillian.core.api.annotation.Inject
    private Instance<Injector> injector;

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(CreationalContextDestroyer.class);
    }

    @Before
    public void setup() throws Exception {
        this.container = SeContainerInitializer.newInstance().addBeanClasses(new Class[]{Service.class, Cat.class, CatService.class, Dog.class, DogService.class}).initialize();
        this.manager = this.container.getBeanManager();
        this.bind(TestScoped.class, BeanManager.class, this.manager);
        this.enricher = new CDIInjectionEnricher();
        ((Injector)this.injector.get()).inject((Object)this.enricher);
    }

    @org.junit.After
    public void teardown() throws Exception {
        this.container.close();
    }

    @Test
    @Ignore
    public void shouldInjectClassMembers() throws Exception {
        TestClass testClass = new TestClass();
        this.enricher.injectClass((Object)testClass);
        testClass.testMethod(testClass.dogService, testClass.catService);
    }

    @Test
    @Ignore
    public void shouldInjectMethodArguments() throws Exception {
        Method testMethod = TestClass.class.getMethod("testMethod", Service.class, Service.class);
        Object[] resolvedBeans = this.enricher.resolve(testMethod);
        TestClass testClass = new TestClass();
        testMethod.invoke((Object)testClass, resolvedBeans);
    }

    @Test
    @Ignore
    public void shouldInjectMethodArgumentsEvent() throws Exception {
        Method testMethod = TestClass.class.getMethod("testEvent", Event.class, Event.class);
        Object[] resolvedBeans = this.enricher.resolve(testMethod);
        TestClass testClass = new TestClass();
        testMethod.invoke((Object)testClass, resolvedBeans);
    }

    @Test
    @Ignore
    public void shouldReleaseCreationalContext() throws Exception {
        TestClass testClass = new TestClass();
        this.enricher.injectClass((Object)testClass);
        this.fire(new After((Object)this, TestClass.class.getMethod("validateReleased", new Class[0])));
        testClass.validateReleased();
    }

    @Test
    @Ignore
    public void shouldInjectMethodArgumentsInstance() throws Exception {
        Method testMethod = TestClass.class.getMethod("testInstance", jakarta.enterprise.inject.Instance.class, jakarta.enterprise.inject.Instance.class);
        Object[] resolvedBeans = this.enricher.resolve(testMethod);
        TestClass testClass = new TestClass();
        testMethod.invoke((Object)testClass, resolvedBeans);
    }

    private static class TestClass {
        @Inject
        Service<Dog> dogService;
        @Inject
        Service<Cat> catService;

        private TestClass() {
        }

        public void validateReleased() {
            Assert.assertTrue((String)"@PreDestory has been called", (boolean)this.dogService.wasReleased());
            Assert.assertTrue((String)"@PreDestory has been called", (boolean)this.catService.wasReleased());
        }

        public void testMethod(Service<Dog> dogService, Service<Cat> catService) {
            Assert.assertNotNull(catService);
            Assert.assertNotNull(dogService);
            Assert.assertEquals((String)"Injected object should be of type", CatService.class, catService.getClass());
            Assert.assertEquals((String)"Injected object should be of type", DogService.class, dogService.getClass());
        }

        public void testEvent(Event<Dog> dogEvent, Event<Cat> catEvent) {
            Assert.assertNotNull((String)"Generic Event should be injected as MethodArgument", dogEvent);
            Assert.assertNotNull((String)"Generic Event should be injected as MethodArgument", catEvent);
        }

        public void testInstance(jakarta.enterprise.inject.Instance<Dog> dogEvent, jakarta.enterprise.inject.Instance<Cat> catEvent) {
            Assert.assertNotNull((String)"Generic Instance should be injected as MethodArgument", dogEvent);
            Assert.assertNotNull((String)"Generic Instance should be injected as MethodArgument", catEvent);
        }
    }
}

