/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.ejb;

import javax.ejb.EJB;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.testenricher.ejb.EJBInjectionEnricherBase;
import org.junit.Assert;
import org.junit.Test;

public class EJBInjectionEnricher31TestCase
extends EJBInjectionEnricherBase {
    @Test
    public void testResolveJNDINameLookupSpecified() {
        this.cut.enrich((Object)new EJBEnrichedLookupClass());
        String expected = EJBEnrichedLookupClass.class.getDeclaredFields()[0].getAnnotation(EJB.class).lookup();
        Assert.assertThat((Object)this.resolvedJndiName, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.resolvedJndiName.length, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.resolvedJndiName[0], (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionOnMappedNameAndLookup() {
        this.cut.enrich((Object)new EJBInvalidMappedNameAndLookupClass());
        Assert.assertThat((Object)this.caughtResolveException, (Matcher)CoreMatchers.notNullValue());
        throw this.caughtResolveException;
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionOnBeanNameAndLookup() {
        this.cut.enrich((Object)new EJBInvalidBeanNameAndLookupClass());
        Assert.assertThat((Object)this.caughtResolveException, (Matcher)CoreMatchers.notNullValue());
        throw this.caughtResolveException;
    }

    public static final class EJBInvalidBeanNameAndLookupClass {
        @EJB(beanName="any", lookup="any")
        EJBInjectionEnricherBase.ExemplaryEJB lookupInjection;
    }

    public static final class EJBInvalidMappedNameAndLookupClass {
        @EJB(mappedName="any", lookup="any")
        EJBInjectionEnricherBase.ExemplaryEJB lookupInjection;
    }

    public static final class EJBEnrichedLookupClass {
        @EJB(lookup="java:global/org/arquillian/Test")
        EJBInjectionEnricherBase.ExemplaryEJB lookupInjection;
    }
}

