/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.ejb;

import javax.ejb.EJB;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.testenricher.ejb.EJBInjectionEnricherBase;
import org.junit.Assert;
import org.junit.Test;

public class EJBInjectionEnricher30TestCase
extends EJBInjectionEnricherBase {
    @Test
    public void testResolveJNDIName() {
        this.cut.enrich((Object)new EJBEnrichedSimpleInjectionClass());
        Assert.assertThat((Object)(this.resolvedJndiName.length > 5 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testResolveJNDINameMappedNameSpecified() {
        this.cut.enrich((Object)new EJBEnrichedMappedNameClass());
        String expected = EJBEnrichedMappedNameClass.class.getDeclaredFields()[0].getAnnotation(EJB.class).mappedName();
        Assert.assertThat((Object)this.resolvedJndiName, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.resolvedJndiName.length, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.resolvedJndiName[0], (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void testResolveJNDINameBeanNameSpecified() {
        this.cut.enrich((Object)new EJBEnrichedBeanNameClass());
        Class<?> fieldType = EJBEnrichedMappedNameClass.class.getDeclaredFields()[0].getType();
        String[] r = this.resolvedJndiName;
        String expected = "java:module/" + EJBInjectionEnricherBase.ExemplaryEJBMockImpl.class.getSimpleName() + "!" + fieldType.getName();
        Assert.assertThat((Object)r, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)r.length, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)r[0], (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionOnBeanAndMappedName() {
        this.cut.enrich((Object)new EJBInvalidBeanAndMappedNameClass());
        Assert.assertThat((Object)this.caughtResolveException, (Matcher)CoreMatchers.notNullValue());
        throw this.caughtResolveException;
    }

    public static final class EJBInvalidBeanAndMappedNameClass {
        @EJB(beanName="any", mappedName="any")
        EJBInjectionEnricherBase.ExemplaryEJB lookupInjection;
    }

    public static final class EJBEnrichedBeanNameClass {
        @EJB(beanName="ExemplaryEJBMockImpl")
        EJBInjectionEnricherBase.ExemplaryEJB beanNameInjection;
    }

    public static final class EJBEnrichedMappedNameClass {
        @EJB(mappedName="java:module/org/arquillian/Test")
        EJBInjectionEnricherBase.ExemplaryEJB mappedNameInjection;
    }

    public static final class EJBEnrichedSimpleInjectionClass {
        @EJB
        EJBInjectionEnricherBase.ExemplaryEJB simpleInjection;
    }
}

