/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.ejb;

import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.arquillian.testenricher.ejb.EJBInjectionEnricher;
import org.junit.Before;
import org.junit.Test;

public class EJBInjectionEnricherBase {
    protected EJBInjectionEnricher cut;
    protected String[] resolvedJndiName;
    protected RuntimeException caughtResolveException;

    @Before
    public void before() throws Exception {
        this.cut = new EJBInjectionEnricher(){

            protected Context createContext() throws Exception {
                return new InitialContext();
            }

            protected Object lookupEJB(String[] jndiNames) throws Exception {
                EJBInjectionEnricherBase.this.resolvedJndiName = jndiNames;
                return new ExemplaryEJBMockImpl();
            }

            protected String[] resolveJNDINames(Class<?> fieldType, String mappedName, String beanName, String lookup) {
                try {
                    return super.resolveJNDINames(fieldType, mappedName, beanName, lookup);
                }
                catch (RuntimeException e) {
                    EJBInjectionEnricherBase.this.caughtResolveException = e;
                    throw e;
                }
            }
        };
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResolveJNDINameFieldNotSet() {
        this.cut.resolveJNDINames(null, "anyString()", null, null);
    }

    @Stateless
    public static class ExemplaryEJBProductionImpl
    implements ExemplaryEJB {
    }

    @Stateless
    public static class ExemplaryEJBMockImpl
    implements ExemplaryEJB {
    }

    @Local
    public static interface ExemplaryEJB {
    }
}

