/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.ejb;

import javax.ejb.EJB;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.arquillian.testenricher.ejb.EJBInjectionEnricherBase;
import org.junit.Test;

public class EJBInjectionEnricher30TestCase
extends EJBInjectionEnricherBase {
    @Test
    public void testResolveJNDIName() {
        this.cut.enrich((Object)new EJBEnrichedSimpleInjectionClass());
        MatcherAssert.assertThat((Object)(this.resolvedJndiName.length > 5 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testResolveJNDINameMappedNameSpecified() {
        this.cut.enrich((Object)new EJBEnrichedMappedNameClass());
        String expected = EJBEnrichedMappedNameClass.class.getDeclaredFields()[0].getAnnotation(EJB.class).mappedName();
        MatcherAssert.assertThat((Object)this.resolvedJndiName, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.resolvedJndiName.length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.resolvedJndiName[0], (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void testResolveJNDINameBeanNameSpecified() {
        this.cut.enrich((Object)new EJBEnrichedBeanNameClass());
        Class<?> fieldType = EJBEnrichedMappedNameClass.class.getDeclaredFields()[0].getType();
        String[] r = this.resolvedJndiName;
        String expected = "java:module/" + EJBInjectionEnricherBase.ExemplaryEJBMockImpl.class.getSimpleName() + "!" + fieldType.getName();
        MatcherAssert.assertThat((Object)r, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)r.length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)r[0], (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionOnBeanAndMappedName() {
        this.cut.enrich((Object)new EJBInvalidBeanAndMappedNameClass());
        MatcherAssert.assertThat((Object)this.caughtResolveException, (Matcher)CoreMatchers.notNullValue());
        throw this.caughtResolveException;
    }

    public static final class EJBEnrichedSimpleInjectionClass {
        @EJB
        EJBInjectionEnricherBase.ExemplaryEJB simpleInjection;
    }

    public static final class EJBEnrichedMappedNameClass {
        @EJB(mappedName="java:module/org/arquillian/Test")
        EJBInjectionEnricherBase.ExemplaryEJB mappedNameInjection;
    }

    public static final class EJBEnrichedBeanNameClass {
        @EJB(beanName="ExemplaryEJBMockImpl")
        EJBInjectionEnricherBase.ExemplaryEJB beanNameInjection;
    }

    public static final class EJBInvalidBeanAndMappedNameClass {
        @EJB(beanName="any", mappedName="any")
        EJBInjectionEnricherBase.ExemplaryEJB lookupInjection;
    }
}

