/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.osgi;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import org.jboss.arquillian.testenricher.osgi.BundleContextProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class PackageAdminProvider
implements ResourceProvider {
    @Inject
    @SuiteScoped
    private InstanceProducer<PackageAdmin> packageAdminProducer;
    @Inject
    private Instance<PackageAdmin> packageAdmin;

    public boolean canProvide(Class<?> type) {
        return type.isAssignableFrom(PackageAdmin.class);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        this.initialize();
        return this.packageAdmin.get();
    }

    private void initialize() {
        BundleContext syscontext = BundleContextProvider.getBundleContext();
        PackageAdmin service = this.getPackageAdmin(syscontext);
        if (service != null) {
            this.packageAdminProducer.set((Object)service);
        }
    }

    private PackageAdmin getPackageAdmin(BundleContext syscontext) {
        PackageAdmin result = null;
        if (syscontext != null) {
            ServiceReference sref = syscontext.getServiceReference(PackageAdmin.class.getName());
            result = (PackageAdmin)syscontext.getService(sref);
        }
        return result;
    }
}

