/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.osgi;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.osgi.StartLevelAware;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.testenricher.osgi.BundleAssociation;
import org.jboss.arquillian.testenricher.osgi.BundleContextProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.startlevel.BundleStartLevel;

public class OSGiTestEnricher
implements TestEnricher {
    private static final Logger log = Logger.getLogger(OSGiTestEnricher.class.getName());

    public void enrich(Object testCase) {
        BundleContext bundleContext = BundleContextProvider.getBundleContext();
        if (bundleContext == null) {
            log.fine("System bundle context not available");
            return;
        }
        Class<?> testClass = testCase.getClass();
        for (Field field : testClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            if (field.getType().isAssignableFrom(BundleContext.class)) {
                this.injectBundleContext(testCase, field);
                continue;
            }
            if (!field.getType().isAssignableFrom(Bundle.class)) continue;
            this.injectBundle(testCase, field);
        }
        for (AccessibleObject accessibleObject : testClass.getDeclaredMethods()) {
            Deployment andep;
            if (!accessibleObject.isAnnotationPresent(Deployment.class) || !(andep = ((Method)accessibleObject).getAnnotation(Deployment.class)).managed() || !andep.testable() || !accessibleObject.isAnnotationPresent(StartLevelAware.class)) continue;
            int bundleStartLevel = ((Method)accessibleObject).getAnnotation(StartLevelAware.class).startLevel();
            Bundle bundle = this.getBundle(testCase);
            log.fine("Setting bundle start level of " + bundle + " to: " + bundleStartLevel);
            BundleStartLevel startLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
            startLevel.setStartLevel(bundleStartLevel);
        }
    }

    public Object[] resolve(Method method) {
        return null;
    }

    private void injectBundleContext(Object testCase, Field field) {
        try {
            BundleContext context = BundleContextProvider.getBundleContext();
            log.warning("Deprecated @Inject BundleContext, use @ArquillianResource BundleContext");
            field.set(testCase, context);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject BundleContext", ex);
        }
    }

    private void injectBundle(Object testCase, Field field) {
        try {
            Bundle bundle = this.getBundle(testCase);
            log.warning("Deprecated @Inject Bundle, use @ArquillianResource Bundle");
            field.set(testCase, bundle);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject Bundle", ex);
        }
    }

    private Bundle getBundle(Object testCase) {
        ClassLoader classLoader;
        Bundle bundle = BundleAssociation.getBundle();
        if (bundle == null && (classLoader = testCase.getClass().getClassLoader()) instanceof BundleReference) {
            BundleReference bref = (BundleReference)classLoader;
            bundle = bref.getBundle();
        }
        return bundle;
    }
}

