/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.resource;

import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.testenricher.resource.ResourceInjectionEnricher;
import org.junit.Assert;
import org.junit.Test;

public class ResourceInjectionEnricherTestCase {
    private final Map<String, Object> injectionValueMap = new HashMap<String, Object>();

    public ResourceInjectionEnricherTestCase() {
        this.injectionValueMap.put("primitive_char", Character.valueOf('1'));
        this.injectionValueMap.put("primitive_byte", Byte.valueOf("1"));
        this.injectionValueMap.put("primitive_int", 10);
        this.injectionValueMap.put("primitive_short", (short)10);
        this.injectionValueMap.put("primitive_long", 10L);
        this.injectionValueMap.put("primitive_float", Float.valueOf(10.0f));
        this.injectionValueMap.put("primitive_double", 10.0);
        this.injectionValueMap.put("primitive_boolean", true);
        this.injectionValueMap.put("primitive_non_default_value", 120);
        this.injectionValueMap.put("primitive", 100);
        this.injectionValueMap.put("primitive2", 100);
        this.injectionValueMap.put("object", this);
        this.injectionValueMap.put("object2", this);
    }

    @Test
    public void shouldInjectResourcesIntoObject() throws Exception {
        InjectableTestClass testClass = new InjectableTestClass();
        new ResourceInjectionEnricher(){

            protected Object lookup(String jndiName) throws Exception {
                return ResourceInjectionEnricherTestCase.this.injectionValueMap.get(jndiName);
            }
        }.injectClass((Object)testClass);
        Assert.assertEquals((String)"Should be able to inject into primitive field", (Object)this.injectionValueMap.get("primitive"), (Object)testClass.getPrimitive());
        Assert.assertEquals((String)"Should be able to inject into primitive setter", (Object)this.injectionValueMap.get("primitive2"), (Object)testClass.getPrimitive2());
        Assert.assertEquals((String)"Should be able to inject into object field", (Object)this.injectionValueMap.get("object"), (Object)testClass.getObject());
        Assert.assertEquals((String)"Should be able to inject into object ssetter", (Object)this.injectionValueMap.get("object2"), (Object)testClass.getObject2());
        Assert.assertEquals((String)"Should inject primitive if it has default value", (Object)this.injectionValueMap.get("primitive_char"), (Object)Character.valueOf(testClass.primitive_char));
        Assert.assertEquals((String)"Should inject primitive if it has default value", (Object)this.injectionValueMap.get("primitive_byte"), (Object)testClass.primitive_byte);
        Assert.assertEquals((String)"Should inject primitive if it has default value", (Object)this.injectionValueMap.get("primitive_int"), (Object)testClass.primitive_int);
        Assert.assertEquals((String)"Should inject primitive if it has default value", (Object)this.injectionValueMap.get("primitive_short"), (Object)testClass.primitive_short);
        Assert.assertEquals((String)"Should inject primitive if it has default value", (Object)this.injectionValueMap.get("primitive_long"), (Object)testClass.primitive_long);
        Assert.assertEquals((String)"Should inject primitive if it has default value", (Object)this.injectionValueMap.get("primitive_float"), (Object)Float.valueOf(testClass.primitive_float));
        Assert.assertEquals((String)"Should inject primitive if it has default value", (Object)this.injectionValueMap.get("primitive_double"), (Object)testClass.primitive_double);
        Assert.assertEquals((String)"Should inject primitive if it has default value", (Object)this.injectionValueMap.get("primitive_boolean"), (Object)testClass.primitive_boolean);
        Assert.assertNotSame((String)"Should not inject primitive if it does not have default value", (Object)this.injectionValueMap.get("primitive_non_default_value"), (Object)testClass.primitive_non_default_value);
    }

    private static class InjectableTestClass {
        @Resource(mappedName="primitive_char")
        public char primitive_char;
        protected int primitive2;
        @Resource(mappedName="primitive_byte")
        byte primitive_byte;
        @Resource(mappedName="primitive_int")
        int primitive_int;
        @Resource(mappedName="primitive_short")
        short primitive_short;
        @Resource(mappedName="primitive_long")
        long primitive_long;
        @Resource(mappedName="primitive_float")
        float primitive_float;
        @Resource(mappedName="primitive_double")
        double primitive_double;
        @Resource(mappedName="primitive_boolean")
        boolean primitive_boolean;
        @Resource(mappedName="primitive_non_default_value")
        int primitive_non_default_value = 100;
        @Resource(mappedName="primitive")
        private int primitive;
        @Resource(mappedName="object")
        private Object object;
        private Object object2;

        private InjectableTestClass() {
        }

        public int getPrimitive() {
            return this.primitive;
        }

        public int getPrimitive2() {
            return this.primitive2;
        }

        @Resource(mappedName="primitive")
        public void setPrimitive2(int primitive2) {
            this.primitive2 = primitive2;
        }

        public Object getObject() {
            return this.object;
        }

        public Object getObject2() {
            return this.object2;
        }

        @Resource(mappedName="object")
        public void setObject2(Object object2) {
            this.object2 = object2;
        }
    }
}

