/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testng.container;

import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.arquillian.testng.container.ShouldProvideConfigurationFailureToTestRunner;
import org.jboss.arquillian.testng.container.ShouldProvideVariousTestResultsToTestRunner;
import org.jboss.arquillian.testng.container.TestNGTestRunner;
import org.junit.Assert;
import org.junit.Test;
import org.testng.SkipException;

public class TestNGTestRunnerTestCase
extends Arquillian {
    @Test
    public void shouldReturnPassedTest() throws Exception {
        TestNGTestRunner runner = new TestNGTestRunner();
        TestResult result = runner.execute(ShouldProvideVariousTestResultsToTestRunner.class, "shouldProvidePassingTestToRunner");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assert.assertNull((Object)result.getThrowable());
    }

    @Test
    public void shouldReturnFailedTest() throws Exception {
        TestNGTestRunner runner = new TestNGTestRunner();
        TestResult result = runner.execute(ShouldProvideVariousTestResultsToTestRunner.class, "shouldProvideFailingTestToRunner");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertEquals(AssertionError.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldReturnSkippedTest() throws Exception {
        TestNGTestRunner runner = new TestNGTestRunner();
        TestResult result = runner.execute(ShouldProvideVariousTestResultsToTestRunner.class, "shouldProvideSkippingTestToRunner");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)TestResult.Status.SKIPPED, (Object)result.getStatus());
        Assert.assertEquals(SkipException.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldReturnFailedTestAfterConfigurationError() throws Exception {
        TestNGTestRunner runner = new TestNGTestRunner();
        TestResult result = runner.execute(ShouldProvideConfigurationFailureToTestRunner.class, "successfulTest");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertEquals(ClassNotFoundException.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldReturnExceptionOnPassedTest() throws Exception {
        TestNGTestRunner runner = new TestNGTestRunner();
        TestResult result = runner.execute(ShouldProvideVariousTestResultsToTestRunner.class, "shouldProvideExpectedExceptionToRunner");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assert.assertNotNull((Object)result.getThrowable());
        Assert.assertEquals(IllegalArgumentException.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldBeAbleToUseOtherDataProviders() throws Exception {
        TestNGTestRunner runner = new TestNGTestRunner();
        TestResult result = runner.execute(ShouldProvideVariousTestResultsToTestRunner.class, "shouldBeAbleToUseOtherDataProviders");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assert.assertNull((Object)result.getThrowable());
    }
}

