/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processors;

import com.google.auto.service.AutoService;
import com.gwtplatform.mvp.client.annotations.NameToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.jboss.as.console.client.plugins.RuntimeExtensionMetaData;
import org.jboss.as.console.client.plugins.SubsystemExtensionMetaData;
import org.jboss.as.console.spi.RuntimeExtension;
import org.jboss.as.console.spi.SubsystemExtension;
import org.jboss.hal.processors.AbstractHalProcessor;

@SupportedAnnotationTypes(value={"org.jboss.as.console.spi.SubsystemExtension", "org.jboss.as.console.spi.RuntimeExtension"})
@AutoService(value=Processor.class)
public class ExtensionProcessor
extends AbstractHalProcessor {
    static final String SUBSYSTEM_EXTENSION_TEMPLATE = "SubsystemExtensions.ftl";
    static final String SUBSYSTEM_EXTENSION_PACKAGE = "org.jboss.as.console.client.plugins";
    static final String SUBSYSTEM_EXTENSION_CLASS = "SubsystemRegistryImpl";
    static final String RUNTIME_EXTENSION_TEMPLATE = "RuntimeExtensions.ftl";
    static final String RUNTIME_EXTENSION_PACKAGE = "org.jboss.as.console.client.plugins";
    static final String RUNTIME_EXTENSION_CLASS = "RuntimeLHSItemExtensionRegistryImpl";
    private final List<SubsystemExtensionMetaData> subsytemExtensions = new ArrayList<SubsystemExtensionMetaData>();
    private final List<RuntimeExtensionMetaData> runtimeExtensions = new ArrayList<RuntimeExtensionMetaData>();

    @Override
    protected boolean onProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        NameToken nameToken;
        TypeElement element;
        for (Element element2 : roundEnv.getElementsAnnotatedWith(SubsystemExtension.class)) {
            element = (TypeElement)element2;
            nameToken = element.getAnnotation(NameToken.class);
            SubsystemExtension subsystemExtension = element.getAnnotation(SubsystemExtension.class);
            if (nameToken == null || subsystemExtension == null) continue;
            this.debug("Processing subsystem extension %s -> %s", subsystemExtension.name(), nameToken.value()[0]);
            SubsystemExtensionMetaData smd = new SubsystemExtensionMetaData(subsystemExtension.name(), nameToken.value()[0], subsystemExtension.group(), subsystemExtension.key());
            this.subsytemExtensions.add(smd);
        }
        for (Element element3 : roundEnv.getElementsAnnotatedWith(RuntimeExtension.class)) {
            element = (TypeElement)element3;
            nameToken = element.getAnnotation(NameToken.class);
            RuntimeExtension runtimeExtension = element.getAnnotation(RuntimeExtension.class);
            if (nameToken == null || runtimeExtension == null) continue;
            this.debug("Processing runtime extension %s -> %s", runtimeExtension.name(), nameToken.value()[0]);
            RuntimeExtensionMetaData rmd = new RuntimeExtensionMetaData(runtimeExtension.name(), nameToken.value()[0], runtimeExtension.group(), runtimeExtension.key());
            this.runtimeExtensions.add(rmd);
        }
        if (!this.subsytemExtensions.isEmpty()) {
            this.debug("Generating subsystem extension registry", new Object[0]);
            this.code(SUBSYSTEM_EXTENSION_TEMPLATE, "org.jboss.as.console.client.plugins", SUBSYSTEM_EXTENSION_CLASS, () -> {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("packageName", "org.jboss.as.console.client.plugins");
                context.put("className", SUBSYSTEM_EXTENSION_CLASS);
                context.put("subsystemExtensions", this.subsytemExtensions);
                return context;
            });
            this.info("Successfully generated subsystem extension registry [%s].", SUBSYSTEM_EXTENSION_CLASS);
            this.subsytemExtensions.clear();
        }
        if (!this.runtimeExtensions.isEmpty()) {
            this.debug("Generating runtime extension registry", new Object[0]);
            this.code(RUNTIME_EXTENSION_TEMPLATE, "org.jboss.as.console.client.plugins", RUNTIME_EXTENSION_CLASS, () -> {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("packageName", "org.jboss.as.console.client.plugins");
                context.put("className", RUNTIME_EXTENSION_CLASS);
                context.put("runtimeExtensions", this.runtimeExtensions);
                return context;
            });
            this.info("Successfully generated runtime extension registry [%s].", RUNTIME_EXTENSION_CLASS);
            this.runtimeExtensions.clear();
        }
        return false;
    }
}

