/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.dmr;

import java.io.IOException;
import java.net.UnknownHostException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.hal.testsuite.cli.Library;
import org.jboss.hal.testsuite.cli.TimeoutException;
import org.jboss.hal.testsuite.dmr.DmrException;
import org.jboss.hal.testsuite.dmr.DmrResponse;
import org.jboss.hal.testsuite.dmr.Operation;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dispatcher {
    private static final Logger log = LoggerFactory.getLogger(Dispatcher.class);
    private static final String MANAGEMENT_HOST = ConfigUtils.get("as.managementAddress");
    private static final int MANAGEMENT_PORT = Integer.valueOf(ConfigUtils.get("as.managementPort"));
    private static final String USERNAME = "authentication";
    private static final String PASSWORD = "must be disabled";
    private static final int WAIT = 200;
    private ModelControllerClient client;

    public Dispatcher() {
        try {
            this.client = ModelControllerClient.Factory.create((String)MANAGEMENT_HOST, (int)MANAGEMENT_PORT, (CallbackHandler)new AuthCallback(new String[]{USERNAME, PASSWORD}));
        }
        catch (UnknownHostException e) {
            throw new DmrException(e);
        }
    }

    public DmrResponse execute(Operation operation) {
        log.debug("Executing operation {}", (Object)operation);
        try {
            long start = System.currentTimeMillis();
            DmrResponse response = this.executeSingle(operation);
            if (operation.getTimeout() > 0) {
                while (!response.isSuccessful()) {
                    if (System.currentTimeMillis() >= start + (long)operation.getTimeout()) {
                        throw new TimeoutException(operation.toString(), operation.getTimeout());
                    }
                    Library.letsSleep(200L);
                    response = this.executeSingle(operation);
                }
            }
            log.info("Operation {} finished with {}", (Object)operation, (Object)(response.isSuccessful() ? "success" : "failure"));
            if (!response.isSuccessful()) {
                log.warn("Operation '{}' failed because of '{}'.", (Object)operation, (Object)response.getFailureDescription().asString());
            }
            return response;
        }
        catch (IOException e) {
            throw new DmrException(operation, e);
        }
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new DmrException(e);
        }
    }

    private DmrResponse executeSingle(Operation operation) throws IOException {
        ModelNode response = this.client.execute((ModelNode)operation);
        return new DmrResponse(response);
    }

    private static class AuthCallback
    implements CallbackHandler {
        String[] args;

        public AuthCallback(String[] args) {
            this.args = args;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.args[0]);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.args[1].toCharArray());
                    continue;
                }
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    rcb.setText(rcb.getDefaultText());
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }
}

