/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.finder;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.hal.testsuite.finder.Column;
import org.jboss.hal.testsuite.finder.PreviewFragment;
import org.jboss.hal.testsuite.finder.Row;
import org.jboss.hal.testsuite.page.BasePage;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.Find;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinderNavigation {
    private static final Logger log = LoggerFactory.getLogger(FinderNavigation.class);
    private static final String WILDCARD = "*";
    private final WebDriver browser;
    private final Class<? extends BasePage> page;
    private final List<AddressTuple> address;
    private final Hook hook;
    private boolean refresh;
    private int naviRetriesNo = 0;

    public FinderNavigation(WebDriver browser, Class<? extends BasePage> page, Hook hook) {
        this.browser = browser;
        this.page = page;
        this.hook = hook;
        this.address = new ArrayList<AddressTuple>();
        this.refresh = true;
    }

    public FinderNavigation(WebDriver browser, Class<? extends BasePage> page, long clickDelay) {
        this(browser, page, () -> {
            try {
                Thread.sleep(clickDelay);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public FinderNavigation(WebDriver browser, Class<? extends BasePage> page) {
        this(browser, page, () -> {});
    }

    public FinderNavigation step(String column) {
        this.address.add(new AddressTuple(column, WILDCARD));
        return this;
    }

    public FinderNavigation step(String column, String row) {
        this.address.add(new AddressTuple(column, row));
        return this;
    }

    public Column selectColumn() {
        WebElement column = this.navigate()[0];
        if (column == null) {
            throw new IllegalStateException("No address for selecting a column given");
        }
        return (Column)Graphene.createPageFragment(Column.class, (WebElement)column);
    }

    public Column selectColumn(Boolean exactRowText) {
        WebElement column = this.navigate(exactRowText)[0];
        if (column == null) {
            throw new IllegalStateException("No address for selecting a column given");
        }
        return (Column)Graphene.createPageFragment(Column.class, (WebElement)column);
    }

    public Row selectRow() {
        WebElement row = this.navigate()[1];
        if (row == null) {
            throw new IllegalStateException("No address for selecting a row given.");
        }
        return (Row)Graphene.createPageFragment(Row.class, (WebElement)row);
    }

    public Row selectRow(Boolean exactRowText) {
        WebElement row = this.navigate(exactRowText)[1];
        if (row == null) {
            throw new IllegalStateException("No address for selecting a row given.");
        }
        return (Row)Graphene.createPageFragment(Row.class, (WebElement)row);
    }

    public PreviewFragment getPreview() {
        By previewSelector = By.className((String)"preview-content");
        Graphene.waitGui().until().element(previewSelector).is().visible();
        WebElement preview = this.browser.findElement(previewSelector);
        return (PreviewFragment)Graphene.createPageFragment(PreviewFragment.class, (WebElement)preview);
    }

    private WebElement[] navigate() {
        return this.navigate(false);
    }

    private WebElement[] navigate(Boolean exactRowText) {
        WebElement[] columnRow = new WebElement[2];
        if (this.refresh) {
            Console.withBrowser(this.browser).waitForFirstNavigationPanel(this.page);
        }
        for (int i = 0; i < this.address.size(); ++i) {
            AddressTuple tuple = this.address.get(i);
            columnRow[0] = this.browser.findElement(this.columnSelector(tuple.column));
            if (WILDCARD.equals(tuple.row)) continue;
            By rowSelector = exactRowText != false ? this.rowSelectorEquals(tuple.row) : this.rowSelector(tuple.row);
            columnRow[1] = new Find().elementWithGuiTimeout((SearchContext)columnRow[0], rowSelector);
            if (!columnRow[1].isDisplayed()) {
                ((JavascriptExecutor)this.browser).executeScript("arguments[0].scrollIntoView(true);", new Object[]{columnRow[1]});
            }
            columnRow[1].click();
            this.hook.performAfterRowClick();
            Graphene.waitModel().until().element((SearchContext)columnRow[0], rowSelector).attribute("class").contains("cellTableSelectedRowCell");
            if (i >= this.address.size() - 1) continue;
            AddressTuple nextTuple = this.address.get(i + 1);
            try {
                Graphene.waitModel().until().element(this.columnSelector(nextTuple.column)).is().visible();
                continue;
            }
            catch (TimeoutException e) {
                if (ConfigUtils.get("jbeap2168workaround") != null && this.naviRetriesNo++ < 3) {
                    log.warn("Navigation frozen! JBEAP-2168 needs to be fixed!");
                    return this.navigate(exactRowText);
                }
                this.naviRetriesNo = 0;
                throw new TimeoutException("Navigation frozen! Probably due to https://issues.jboss.org/browse/JBEAP-2168.", (Throwable)e);
            }
        }
        this.naviRetriesNo = 0;
        return columnRow;
    }

    public FinderNavigation resetNavigation() {
        this.address.clear();
        this.refresh = false;
        return this;
    }

    public void clearNavigation() {
        if (this.address.size() > 0) {
            this.address.clear();
        }
    }

    private By columnSelector(String name) {
        return By.cssSelector((String)("[data-column=\"" + name + "\"]"));
    }

    By rowSelectorEquals(String label) {
        return this.getRowSelector(" and text()='" + label + "']]");
    }

    By rowSelector(String label) {
        return this.getRowSelector(" and contains(.,'" + label + "')]]");
    }

    private By getRowSelector(String xpathSuffix) {
        String cellClass = PropUtils.get("table.cell.class");
        return By.ByXPath.xpath((String)(".//td[contains(@class,'" + cellClass + "') and descendant::div[@class='navigation-column-item'" + xpathSuffix));
    }

    public static interface Hook {
        public void performAfterRowClick();
    }

    private static class AddressTuple {
        final String column;
        final String row;

        AddressTuple(String column, String row) {
            this.column = column;
            this.row = row;
        }
    }
}

