/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.fragment.ConfigAreaFragment;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.WindowState;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.fragment.shared.modal.WizardWindow;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.util.Console;

public class FederationPage
extends ConfigurationPage {
    private static final String PICKETLINK = "PicketLink";
    private static final String FEDERATION = "Federation";
    private static final String SERVICE_PROVIDER = "Service Provider";

    public WizardWindow addFederationWindow() {
        this.getSubsystemNavigation(PICKETLINK).step(FEDERATION).selectColumn().invoke("Add");
        return Console.withBrowser(this.browser).openedWizard();
    }

    public WindowState removeFederation(String federationName) {
        this.getSubsystemNavigation(PICKETLINK).step(FEDERATION, federationName).selectRow().invoke("Remove");
        return Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirm();
    }

    public FederationPage navigateToFederation(String federationName) {
        this.getSubsystemNavigation(PICKETLINK).step(FEDERATION, federationName).selectRow().invoke("View");
        Application.waitUntilVisible();
        return this;
    }

    public WizardWindow addSpWindow(String federationName) {
        this.getSubsystemNavigation(PICKETLINK).step(FEDERATION, federationName).step(SERVICE_PROVIDER).selectColumn().invoke("Add");
        return Console.withBrowser(this.browser).openedWizard();
    }

    public WindowState removeSp(String federationName, String spName) {
        this.getSubsystemNavigation(PICKETLINK).step(FEDERATION, federationName).step(SERVICE_PROVIDER, spName).selectRow().invoke("Remove");
        return Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirm();
    }

    public FederationPage navigateToServiceProvider(String federationName, String spName) {
        this.getSubsystemNavigation(PICKETLINK).step(FEDERATION, federationName).step(SERVICE_PROVIDER, spName).selectRow().invoke("View");
        Application.waitUntilVisible();
        return this;
    }

    public ConfigFragment switchConfigAreaTabTo(String tabLabel) {
        return this.getConfig(ConfigAreaFragment.class).switchTo(tabLabel);
    }
}

