/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.cli.TimeoutException;
import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.page.runtime.DomainRuntimeEntryPoint;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.Console;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class ServerConfigurationPage
extends ConfigurationPage {
    public void goToServerProperties(String server) {
        FinderNavigation navigation = new FinderNavigation(this.browser, DomainRuntimeEntryPoint.class).step("Browse Domain By", "Hosts").step("Host", ConfigUtils.getDefaultHost()).step("Server", server);
        navigation.selectRow().invoke("View");
        Application.waitUntilVisible();
        this.browser.findElement((By)ByJQuery.selector((String)"div.gwt-Label:contains(System Properties)")).click();
    }

    public void addProperty(String name, String value) {
        WebElement add = this.browser.findElement(By.id((String)"gwt-debug-addBtnPropertyEditor"));
        add.click();
        this.getWindowFragment().getEditor().text("key", name);
        this.getWindowFragment().getEditor().text("value", value);
        this.getWindowFragment().save();
    }

    public void removeProperty(String name) {
        this.getResourceManager().getResourceTable().selectRowByText(0, name);
        this.browser.findElement(By.xpath((String)"//button[contains(text(), 'Remove')]")).click();
        try {
            Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirm();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void clickExpressionResolver() {
        WebElement tools = this.browser.findElement((By)ByJQuery.selector((String)"div.gwt-HTML.footer-link:contains(Tools)"));
        tools.click();
        this.browser.findElement(By.xpath((String)"//div[@class='popupContent']//a[contains(text(), 'Expression Resolver')]")).click();
    }

    public ConfigFragment getWindowFragment() {
        WebElement editPanel = this.browser.findElement(By.className((String)"default-window-content"));
        return (ConfigFragment)Graphene.createPageFragment(ConfigFragment.class, (WebElement)editPanel);
    }
}

