/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.hal.testsuite.cli.Library;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.PopUpFragment;
import org.jboss.hal.testsuite.fragment.UserFragment;
import org.jboss.hal.testsuite.fragment.WindowFragment;
import org.jboss.hal.testsuite.fragment.formeditor.PropertyEditor;
import org.jboss.hal.testsuite.fragment.shared.modal.ReloadRequiredWindow;
import org.jboss.hal.testsuite.fragment.shared.modal.WizardWindow;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableFragment;
import org.jboss.hal.testsuite.page.BasePage;
import org.jboss.hal.testsuite.page.home.HomePage;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console {
    private static final Logger log = LoggerFactory.getLogger(Console.class);
    private WebDriver browser;

    public static Console withBrowser(WebDriver browser) {
        Console console = new Console();
        console.browser = browser;
        return console;
    }

    private Console() {
    }

    public Console waitUntilLoaded() {
        ((IsElementBuilder)Graphene.waitModel().withTimeout(30L, TimeUnit.SECONDS).until().element(By.className((String)"hal-ProgressElement")).is().not()).visible();
        return this;
    }

    public void refresh() {
        this.browser.navigate().refresh();
        this.waitUntilFinished();
    }

    public void waitForContent() {
        Graphene.waitAjax().until().element(By.className((String)"content-header-label")).is().present();
    }

    public void waitUntilFinished() {
        By selector = By.className((String)"hal-ProgressElement");
        ((IsElementBuilder)Graphene.waitModel().until().element(selector).is().not()).visible();
    }

    public <T extends PopUpFragment> T openedPopup(Class<T> clazz, By selector) {
        Graphene.waitGui().until().element(PopUpFragment.ROOT_SELECTOR).is().present();
        WebElement popupRoot = this.browser.findElement(selector);
        PopUpFragment popup = (PopUpFragment)Graphene.createPageFragment(clazz, (WebElement)popupRoot);
        return (T)popup;
    }

    public <T extends PopUpFragment> T openedPopup(Class<T> clazz) {
        return this.openedPopup(clazz, PopUpFragment.ROOT_SELECTOR);
    }

    public PopUpFragment openedPopup() {
        return this.openedPopup(PopUpFragment.class, PopUpFragment.ROOT_SELECTOR);
    }

    public <T extends WindowFragment> T openedWindow(Class<T> clazz, By selector) {
        Graphene.waitGui().until().element(selector).is().present();
        WebElement windowRoot = this.browser.findElement(selector);
        WindowFragment window = (WindowFragment)Graphene.createPageFragment(clazz, (WebElement)windowRoot);
        return (T)window;
    }

    public <T extends WindowFragment> T openedWindow(Class<T> clazz) {
        return this.openedWindow(clazz, WindowFragment.ROOT_SELECTOR);
    }

    public <T extends WindowFragment> T openedWindow(String headTitle, Class<T> clazz) {
        By selector = WindowFragment.ROOT_SELECTOR;
        Graphene.waitGui().until().element(selector).is().present();
        List windowEelements = this.browser.findElements(selector);
        WindowFragment window = null;
        for (WebElement el : windowEelements) {
            window = (WindowFragment)Graphene.createPageFragment(clazz, (WebElement)el);
            if (!window.getHeadTitle().equals(headTitle)) continue;
            return (T)window;
        }
        throw new NoSuchElementException("Unable to find window with title '" + headTitle + "' using " + selector);
    }

    public WindowFragment openedWindow() {
        return this.openedWindow(WindowFragment.class, WindowFragment.ROOT_SELECTOR);
    }

    public int getWindowCount(By selector) {
        List elements = this.browser.findElements(selector);
        return elements.size();
    }

    public int getWindowCount() {
        return this.getWindowCount(WindowFragment.ROOT_SELECTOR);
    }

    public boolean isWindowOpen(By selector, long time, TimeUnit unit) {
        this.browser.manage().timeouts().implicitlyWait(time, unit);
        try {
            ((IsElementBuilder)Graphene.waitModel().withTimeout(time, unit).until().element(selector).is().not()).visible();
            return false;
        }
        catch (TimeoutException e) {
            return true;
        }
    }

    public boolean isWindowOpen() {
        return this.isWindowOpen(WindowFragment.ROOT_SELECTOR, 5L, TimeUnit.SECONDS);
    }

    public <T extends WizardWindow> T openedWizard(Class<T> clazz) {
        return (T)((WizardWindow)this.openedWindow(clazz));
    }

    public WizardWindow openedWizard() {
        return this.openedWindow(WizardWindow.class);
    }

    public <T extends ResourceTableFragment> T getTableByHeader(String label, Class<T> clazz, WebElement root) {
        String cssClass = PropUtils.get("resourcetable.class");
        String tableSelector = "table[contains(@class, '" + cssClass + "')]";
        String headerSelector = "//th/descendant-or-self::*[contains(text(), '" + label + "')]";
        By selector = By.xpath((String)(".//" + tableSelector + headerSelector + "/ancestor::" + tableSelector));
        WebElement tableRoot = this.findElement(selector, root);
        ResourceTableFragment table = (ResourceTableFragment)Graphene.createPageFragment(clazz, (WebElement)tableRoot);
        return (T)table;
    }

    public ResourceTableFragment getTableByHeader(String label) {
        return this.getTableByHeader(label, ResourceTableFragment.class, null);
    }

    public PropertyEditor getPropertyEditor(WebElement root) {
        PropertyEditor properties = (PropertyEditor)Graphene.createPageFragment(PropertyEditor.class, (WebElement)root);
        return properties;
    }

    public WebElement findElement(By selector, WebElement root) {
        WebElement element = null;
        if (root == null) {
            element = this.browser.findElement(selector);
        } else {
            if (!root.isDisplayed()) {
                log.warn("Looking for element in hidden root!");
            }
            element = root.findElement(selector);
        }
        return element;
    }

    public WebElement findElement(By selector, BaseFragment fragment) {
        WebElement root = fragment.getRoot();
        return this.findElement(selector, root);
    }

    public Console maximizeWindow() {
        int maxWidth = Integer.parseInt(ConfigUtils.get("window.max.width", "1920"));
        int maxHeight = Integer.parseInt(ConfigUtils.get("window.max.height", "1080"));
        Dimension maxDimension = new Dimension(maxWidth, maxHeight);
        this.browser.manage().window().setSize(maxDimension);
        return this;
    }

    public void pageDown() {
        List elements = this.browser.findElements(By.id((String)PropUtils.get("page.scrollpanel.id")));
        elements.stream().filter(WebElement::isDisplayed).forEach(e -> e.sendKeys(new CharSequence[]{Keys.PAGE_DOWN}));
        Library.letsSleep(100L);
    }

    public <T extends BasePage> Console refreshAndNavigate(Class<T> clazz) {
        this.browser.navigate().refresh();
        Graphene.goTo(HomePage.class);
        this.waitUntilLoaded();
        Graphene.goTo(clazz);
        this.waitUntilLoaded().maximizeWindow();
        return this;
    }

    public <T extends BasePage> Console waitForFirstNavigationPanel(Class<T> clazz) {
        this.refreshAndNavigate(clazz);
        Graphene.waitModel().until().element(By.className((String)"navigation-column")).is().visible();
        return this;
    }

    public UserFragment getUserFragment() {
        ByJQuery selector = ByJQuery.selector((String)("." + PropUtils.get("header.textlink.class") + ":has(i." + PropUtils.get("icon.user.class") + ")"));
        return (UserFragment)Graphene.createPageFragment(UserFragment.class, (WebElement)this.browser.findElement((By)selector));
    }

    public void logout() {
        this.getUserFragment().openMenu().logout();
    }

    public void dismissReloadRequiredWindowIfPresent() {
        try {
            ByJQuery popupMessageTitleSelector = ByJQuery.selector((String)("." + PropUtils.get("modals.window.title.class") + ":contains('Message')"));
            Graphene.waitGui().until().element((By)popupMessageTitleSelector).is().present();
            this.openedWindow("Message", ReloadRequiredWindow.class).dismiss();
        }
        catch (TimeoutException e) {
            log.debug("Reload required message window not present e.g. since it was already closed before.");
        }
    }
}

