/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.cli;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.cli.scriptsupport.CLI;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.hal.testsuite.cli.CliConfiguration;
import org.jboss.hal.testsuite.cli.CliUtils;
import org.jboss.hal.testsuite.cli.Library;
import org.jboss.hal.testsuite.cli.ServerManager;
import org.jboss.hal.testsuite.cli.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CliClient {
    private static final Logger log = LoggerFactory.getLogger(CliClient.class);
    private final CliConfiguration cliConfig;

    CliClient() {
        this.cliConfig = new CliConfiguration();
    }

    CliClient(CliConfiguration cliConfig) {
        this.cliConfig = cliConfig;
    }

    public CLI.Result executeCommand(String command) {
        CLI cli = CLI.newInstance();
        log.trace("Connecting to native interface (" + this.cliConfig.getHost() + ":" + this.cliConfig.getPort() + ") via CLI");
        cli.connect(this.cliConfig.getHost(), this.cliConfig.getPort(), this.cliConfig.getUser(), this.cliConfig.getPassword());
        log.debug("Running cli command: " + command);
        CLI.Result result = cli.cmd(command);
        log.info("Command {} finished with {}", (Object)result.getCliCommand(), (Object)(result.isSuccess() ? "success" : "failure"));
        log.trace("The command {} ended with response {}", (Object)result.getCliCommand(), (Object)result.getResponse());
        cli.disconnect();
        log.trace("Successfully disconnected");
        return result;
    }

    public ModelNode executeForResponse(String command) {
        CLI.Result result = this.executeCommand(command);
        return result.getResponse();
    }

    public boolean executeForSuccess(String command) {
        return this.executeForSuccess(command, 0);
    }

    public boolean executeForSuccess(String command, int timeout) {
        long start = System.currentTimeMillis();
        boolean successful = this.executeCommand(command).isSuccess();
        if (timeout > 0) {
            while (!successful) {
                if (System.currentTimeMillis() >= start + (long)timeout) {
                    throw new TimeoutException(command, timeout);
                }
                Library.letsSleep(200L);
            }
        }
        return successful;
    }

    public String executeForResult(String command) {
        return this.executeForResult(command, 0);
    }

    public String executeForResult(String command, int timeout) {
        long start = System.currentTimeMillis();
        CLI.Result result = this.executeCommand(command);
        if (timeout > 0) {
            while (!result.isSuccess()) {
                if (System.currentTimeMillis() >= start + (long)timeout) {
                    throw new TimeoutException(command, timeout);
                }
                Library.letsSleep(200L);
            }
        }
        return result.getResponse().get("result").asString();
    }

    public CLI getCLI() {
        CLI cli = CLI.newInstance();
        log.debug("Connecting to native interface (" + this.cliConfig.getHost() + ":" + this.cliConfig.getPort() + ") via CLI");
        cli.connect(this.cliConfig.getHost(), this.cliConfig.getPort(), this.cliConfig.getUser(), this.cliConfig.getPassword());
        return cli;
    }

    public String readAttribute(String address, String name) {
        return this.readAttribute(address, name, true, 0);
    }

    public String readAttribute(String address, String name, int timeout) {
        return this.readAttribute(address, name, true, timeout);
    }

    public String readAttribute(String address, String name, boolean includeDefaults) {
        return this.readAttribute(address, name, includeDefaults, 0);
    }

    public String readAttribute(String address, String name, boolean includeDefaults, int timeout) {
        String command = CliUtils.buildCommand(address, ":read-attribute", new String[]{"name=" + name, "include-defaults=" + String.valueOf(includeDefaults)});
        return this.executeForResult(command, timeout);
    }

    public ModelType readAttributeType(String address, String name) {
        String command = CliUtils.buildCommand(address, ":read-resource-description");
        CLI.Result res = this.executeCommand(command);
        if (res.isSuccess() && res.getResponse().get("result").get("attributes").hasDefined(name)) {
            return ModelType.valueOf((String)res.getResponse().get("result").get("attributes").get(name).get("type").asString().toUpperCase());
        }
        return null;
    }

    public boolean writeAttribute(String address, String name, String value) {
        String valueInImprovedFormat = value;
        if (!"undefined".equals(value) && ModelType.STRING.equals((Object)this.readAttributeType(address, name))) {
            valueInImprovedFormat = "\"" + value.replaceAll("\\\\", "\\\\\\\\") + "\"";
        }
        String[] attributes = new String[]{"name=" + name, "value=" + valueInImprovedFormat};
        String command = CliUtils.buildCommand(address, ":write-attribute", attributes);
        return this.executeForSuccess(command);
    }

    public String getSystemProperty(String name) {
        return this.readAttribute("/system-property=" + name, "value");
    }

    public boolean addSystemProperty(String name, String value) {
        String command = CliUtils.buildCommand("/system-property=" + name, ":add", new String[]{"value=" + value});
        return this.executeForSuccess(command);
    }

    public boolean removeSystemProperty(String name) {
        String command = CliUtils.buildCommand("/system-property=" + name, ":remove", new String[0]);
        return this.executeForSuccess(command);
    }

    public boolean removeResource(String dmrPath) {
        String command = CliUtils.buildCommand(dmrPath, ":remove");
        return this.executeForSuccess(command);
    }

    public boolean reloadRequired() {
        String result = this.readAttribute(null, "server-state");
        return result.equals("reload-required");
    }

    public boolean reloadRequired(ModelNode response) {
        String result = response.get("response-headers").get("process-state").asString();
        System.out.println(response);
        return result.equals("reload-required");
    }

    public boolean restartRequired() {
        String result = this.readAttribute(null, "server-state");
        return result.equals("restart-required");
    }

    public boolean restartRequired(ModelNode response) {
        String result = response.get("response-headers").get("process-state").asString();
        System.out.println(response);
        return result.equals("restart-required");
    }

    public boolean reload() {
        this.executeCommand("reload");
        Library.letsSleep(500L);
        return ServerManager.getInstance(this).waitUntilAvailable();
    }

    public void reload(boolean forced) {
        if (forced || this.reloadRequired()) {
            this.reload();
        }
    }

    public void restart(boolean forced) {
        if (forced || this.restartRequired()) {
            this.restart();
        }
    }

    public boolean restart() {
        this.executeCommand("shutdown --restart=true");
        Library.letsSleep(1500L);
        return ServerManager.getInstance(this).waitUntilAvailable();
    }

    public List<String> getChildNames(String nodeAddress, String childNodeType) {
        ArrayList<String> list = new ArrayList<String>();
        String cmd = CliUtils.buildCommand(nodeAddress, ":read-children-names", new String[]{"child-type=" + childNodeType});
        List asList = this.executeForResponse(cmd).get("result").asList();
        for (ModelNode modelNode : asList) {
            list.add(modelNode.asString());
        }
        return list;
    }

    public boolean hasChildNode(String parentAddress, String childNodeType) {
        return !this.getChildNames(parentAddress, childNodeType).isEmpty();
    }

    public boolean childNodeExists(String parentAddress, String childNodeType, String childNodeName) {
        if (childNodeName == null) {
            throw new IllegalArgumentException("Child node name cannot be null");
        }
        List<String> childNodeList = this.getChildNames(parentAddress, childNodeType);
        return childNodeList.contains(childNodeName);
    }

    public String resolveFullPath(String pathName) {
        log.debug("Resolving full path of " + pathName);
        String path = this.readAttribute("/path=" + pathName, "path");
        log.debug("Resolved path");
        String relativeTo = this.readAttribute("/path=" + pathName, "relative-to");
        if (relativeTo == null || relativeTo.isEmpty() || relativeTo.equals("undefined")) {
            return new File(path).getAbsolutePath();
        }
        return new File(this.resolveFullPath(relativeTo), path).getPath();
    }

    public int getStatusManagerPort() {
        String address = "/socket-binding-group=standard-sockets/socket-binding=txn-status-manager";
        return Integer.parseInt(this.readAttribute("/socket-binding-group=standard-sockets/socket-binding=txn-status-manager", "port"));
    }

    public int getRecoveryListenerPort() {
        String address = "/socket-binding-group=standard-sockets/socket-binding=txn-recovery-environment";
        return Integer.parseInt(this.readAttribute("/socket-binding-group=standard-sockets/socket-binding=txn-recovery-environment", "port"));
    }

    public String getHost() {
        return this.cliConfig.getHost();
    }
}

