/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment;

import java.util.Map;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.MetricsFragment;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class MetricsAreaFragment
extends BaseFragment {
    private Map<String, String> metricGrid;

    public void setMetricGrid(Map<String, String> metricGrid) {
        this.metricGrid = metricGrid;
    }

    public MetricsFragment getMetricsFragment(String text) {
        return this.getMetricsFragment(text, MetricsFragment.class);
    }

    public double getPercentage(String dividendLabel, String divisorLabel) {
        double divisor = this.getMetricNumber(divisorLabel);
        if (divisor == 0.0) {
            return 0.0;
        }
        return this.getMetricNumber(dividendLabel) * 100.0 / divisor;
    }

    public <T extends MetricsFragment> T getMetricsFragment(String text, Class<T> clazz) {
        By elementSelector = By.xpath((String)(".//*[name()='svg']//*[name()='g']/*[name()='text'][contains(text(),'" + text + "')]/../.."));
        WebElement element = this.root.findElement(elementSelector);
        MetricsFragment content = (MetricsFragment)Graphene.createPageFragment(clazz, (WebElement)element);
        double maxWidth = Double.parseDouble(element.findElement(By.xpath((String)"./*[name()='g'][1]/*[name()='rect']")).getAttribute("width"));
        double currentWidth = Double.parseDouble(element.findElement(By.xpath((String)"./*[name()='g'][2]/*[name()='rect']")).getAttribute("width"));
        double maxValue = Double.parseDouble(element.findElement(By.xpath((String)"//*[name()='text'][./preceding-sibling::*[name()='text']][last()]")).getText().replace(",", ""));
        content.setMaxWidth(maxWidth);
        content.setCurrentWidth(currentWidth);
        content.setMaxValue(maxValue);
        return (T)content;
    }

    public String getMetric(String key) {
        return this.metricGrid.get(key);
    }

    public double getMetricNumber(String key) {
        return Double.parseDouble(this.metricGrid.get(key));
    }
}

