/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.formeditor;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.formeditor.PropertyEditor;
import org.jboss.hal.testsuite.fragment.formeditor.RadioButtonGroup;
import org.jboss.hal.testsuite.util.Console;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Editor
extends BaseFragment {
    private static final Logger log = LoggerFactory.getLogger(Editor.class);

    public WebElement getText(String identifier) {
        return this.findTextElement(identifier);
    }

    public void text(String identifier, String value) {
        WebElement input = this.getText(identifier);
        if (!input.isDisplayed()) {
            Console.withBrowser(this.browser).pageDown();
        }
        input.clear();
        log.debug("setting value '{}' to the text element '{}'", (Object)value, (Object)identifier);
        Graphene.waitGui().until().element(input).value().equalTo("");
        input.sendKeys(new CharSequence[]{value});
        Graphene.waitGui().until().element(input).value().equalTo(value);
    }

    public String text(String identifier) {
        WebElement input = this.getText(identifier);
        return input.getAttribute("value");
    }

    private WebElement findSelect(String identifier) {
        ByJQuery selector = ByJQuery.selector((String)("select[id$='" + identifier + "']:visible," + "select[name='" + identifier + "']:visible, " + "tr[data-dmr-attr='" + identifier + "'] select:visible, "));
        return this.findElement((By)selector, this.root);
    }

    public void select(String identifier, String value) {
        Select select = new Select(this.findSelect(identifier));
        select.selectByVisibleText(value);
    }

    public String select(String identifier) {
        Select select = new Select(this.findSelect(identifier));
        return select.getFirstSelectedOption().getText();
    }

    public WebElement getPassword(String identifier) {
        return this.findInputElement("password", identifier);
    }

    public void password(String identifier, String value) {
        WebElement input = this.getPassword(identifier);
        input.clear();
        Graphene.waitGui().until().element(input).value().equalTo("");
        input.sendKeys(new CharSequence[]{value});
        log.debug("password '{}' was set", (Object)input.getText());
    }

    public WebElement getFileInputElement(String identifier) {
        return this.findInputElement("file", identifier);
    }

    public void uploadFile(File fileToUpload, String identifier) {
        WebElement fileInput = this.getFileInputElement(identifier);
        log.debug("uploading file '{}'", (Object)fileToUpload.toString());
        fileInput.sendKeys(new CharSequence[]{fileToUpload.getAbsolutePath()});
        Graphene.waitGui().until().element(fileInput).value().equalTo(fileToUpload.getName());
    }

    public WebElement getCheckbox(String identifier) {
        return this.findInputElement("checkbox", identifier);
    }

    public void checkbox(String identifier, boolean value) {
        WebElement input = this.getCheckbox(identifier);
        boolean current = input.isSelected();
        log.debug("{} checkbox '{}'", (Object)(value ? "setting" : "unsetting"), (Object)identifier);
        if (value != current) {
            input.click();
        }
        if (value) {
            Graphene.waitGui().until().element(input).is().selected();
        } else {
            ((IsElementBuilder)Graphene.waitGui().until().element(input).is().not()).selected();
        }
    }

    public boolean checkbox(String identifier) {
        WebElement input = this.getCheckbox(identifier);
        boolean res = input.isSelected();
        log.debug("checkbox '{}' {} set", (Object)identifier, (Object)(res ? "is" : "isn't"));
        return res;
    }

    public PropertyEditor properties() {
        PropertyEditor properties = Console.withBrowser(this.browser).getPropertyEditor(this.root);
        return properties;
    }

    private WebElement findTextElement(String identifier) {
        WebElement text = null;
        try {
            text = this.findInputElement("text", identifier);
        }
        catch (NoSuchElementException | TimeoutException ignore) {
            log.debug("not found - looking for textarea '{}'", (Object)identifier);
            String byIdSelector = "input[id$='" + identifier + "']:visible";
            String byNameSelector = "input[name='" + identifier + "']:visible";
            String byDmrAttrSelector = "tr[data-dmr-attr='" + identifier + "'] textarea:visible";
            ByJQuery selector = ByJQuery.selector((String)(byIdSelector + ", " + byNameSelector + ", " + byDmrAttrSelector));
            text = this.findElement((By)selector, this.root);
        }
        return text;
    }

    private WebElement findInputElement(String type, String identifier) {
        log.debug("looking for the '{}' input element identified by '{}'", (Object)type, (Object)identifier);
        String byIdSelector = "input[type='" + type + "'][id$='" + identifier + "']:visible";
        String byNameSelector = "input[type='" + type + "'][name='" + identifier + "']:visible";
        String byDmrAttrSelector = "tr[data-dmr-attr='" + identifier + "'] input:visible";
        ByJQuery selector = ByJQuery.selector((String)(byIdSelector + ", " + byNameSelector + ", " + byDmrAttrSelector));
        Graphene.waitGui().withTimeout(500L, TimeUnit.MILLISECONDS).until().element((By)selector).is().visible();
        WebElement input = this.findElement((By)selector, this.root);
        if (!input.isDisplayed()) {
            Console.withBrowser(this.browser).pageDown();
        }
        return input;
    }

    private WebElement findElement(By selector, WebElement root) {
        return Console.withBrowser(this.browser).findElement(selector, root);
    }

    private RadioButtonGroup findRadioButton(String name) {
        log.debug("looking for the radio buttons for '{}'", (Object)name);
        RadioButtonGroup button = new RadioButtonGroup(name, this.root);
        return button;
    }

    public void radioButton(String name, int index) {
        RadioButtonGroup button = this.findRadioButton(name);
        log.debug("picking {}-th radio button", (Object)index);
        button.pick(index);
        Graphene.waitGui().until().element(button.getInputElement(index)).is().selected();
    }

    public void radioButton(String name, String value) {
        RadioButtonGroup button = this.findRadioButton(name);
        log.debug("picking radio button with value '{}'", (Object)value);
        button.pick(value);
        Graphene.waitGui().until().element(button.getInputElement(value)).is().selected();
    }

    public String radioButton(String name) {
        RadioButtonGroup button = this.findRadioButton(name);
        String value = button.getValue();
        log.debug("Selected radio button has value {}", (Object)value);
        return value;
    }
}

