/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.hal.testsuite.fragment.config.mail.MailServerFragment;
import org.jboss.hal.testsuite.fragment.config.mail.MailSessionsFragment;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Location(value="#profile")
public class MailSessionsPage
extends ConfigurationPage {
    private static final Logger log = LoggerFactory.getLogger(MailSessionsPage.class);
    private static final By BACK_ANCHOR = ByJQuery.selector((String)"a:contains('Back')");
    private static final By CONTENT = ByJQuery.selector((String)("." + PropUtils.get("page.content.gwt-layoutpanel") + ":visible"));
    private static final By SESSIONCONTENT = ByJQuery.selector((String)("." + PropUtils.get("page.content.rhs.class") + ":visible"));

    public MailSessionsFragment getMailSessions() {
        this.backIfAvailable();
        WebElement root = this.getContentRoot().findElement(CONTENT);
        return (MailSessionsFragment)Graphene.createPageFragment(MailSessionsFragment.class, (WebElement)root);
    }

    public MailServerFragment getMailServers(String jndiName) {
        this.backIfAvailable();
        this.getResourceManager().viewByName(jndiName);
        WebElement fragmentRoot = this.getContentRoot().findElement(CONTENT);
        return (MailServerFragment)Graphene.createPageFragment(MailServerFragment.class, (WebElement)fragmentRoot);
    }

    public MailServerFragment getSesionsServers() {
        WebElement fragmentRoot = this.getContentRoot().findElement(SESSIONCONTENT);
        return (MailServerFragment)Graphene.createPageFragment(MailServerFragment.class, (WebElement)fragmentRoot);
    }

    private void backIfAvailable() {
        try {
            WebElement back = this.getContentRoot().findElement(BACK_ANCHOR);
            if (back.isDisplayed()) {
                back.click();
            }
        }
        catch (NoSuchElementException e) {
            log.debug("No back anchor found");
        }
    }
}

