/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.config.security.SecurityDomainAddWizard;
import org.jboss.hal.testsuite.fragment.formeditor.Editor;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.fragment.shared.modal.WizardWindow;
import org.jboss.hal.testsuite.page.Navigatable;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.page.config.DomainConfigEntryPoint;
import org.jboss.hal.testsuite.page.config.StandaloneConfigEntryPoint;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.Console;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;

public class SecurityPage
extends ConfigurationPage
implements Navigatable {
    private FinderNavigation navigation;
    private static final String SECURITY_DOMAIN = "Security Domain";

    @Override
    public void navigate() {
        this.navigation = ConfigUtils.isDomain() ? new FinderNavigation(this.browser, DomainConfigEntryPoint.class).step("Configuration", "Profiles").step("Profile", ConfigUtils.getDefaultProfile()) : new FinderNavigation(this.browser, StandaloneConfigEntryPoint.class).step("Configuration", "Subsystems");
        this.navigation.step("Subsystem", "Security").step(SECURITY_DOMAIN);
        this.navigation.selectColumn(true);
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        Console.withBrowser(this.browser).waitUntilLoaded();
    }

    public void viewJBossEJBPolicy() {
        this.viewSecurityDomain("jboss-ejb-policy");
    }

    public void viewJBossWebPolicy() {
        this.viewSecurityDomain("jboss-web-policy");
    }

    public void viewOther() {
        this.viewSecurityDomain("other");
    }

    public SecurityDomainAddWizard addSecurityDomain() {
        this.navigation.resetNavigation().step(SECURITY_DOMAIN).selectColumn().invoke("Add");
        return Console.withBrowser(this.browser).openedWindow(SecurityDomainAddWizard.class);
    }

    public void viewSecurityDomain(String name) {
        this.navigation.resetNavigation().step(SECURITY_DOMAIN, name).selectRow().invoke("View");
        Application.waitUntilVisible();
    }

    public void switchToAuthentication() {
        this.switchSubTab("Authentication");
    }

    public void switchToAuthorization() {
        this.switchSubTab("Authorization");
    }

    public void switchToAudit() {
        this.switchSubTab("Audit");
    }

    public void switchToACL() {
        this.switchSubTab("ACL");
    }

    public void switchToMapping() {
        this.switchSubTab("Mapping");
    }

    public void switchToIdentityTrust() {
        this.switchSubTab("Identity Trust");
    }

    public void addAuthenticationModule(String name, String code) {
        WizardWindow wizard = this.getResourceManager().addResource();
        Editor editor = wizard.getEditor();
        editor.text("name", name);
        editor.text("code", code);
        editor.select("flag", "optional");
        wizard.finish();
    }

    public void addACLModule(String name, String code) {
        WizardWindow wizard = this.getResourceManager().addResource();
        Editor editor = wizard.getEditor();
        editor.text("name", name);
        editor.text("code", code);
        editor.select("flag", "optional");
        wizard.finish();
    }

    public void addAuditModule(String name, String code) {
        WizardWindow wizard = this.getResourceManager().addResource();
        Editor editor = wizard.getEditor();
        editor.text("name", name);
        editor.text("code", code);
        wizard.finish();
    }

    public void addTrustModule(String name, String code) {
        WizardWindow wizard = this.getResourceManager().addResource();
        Editor editor = wizard.getEditor();
        editor.text("name", name);
        editor.text("code", code);
        editor.select("flag", "optional");
        wizard.finish();
    }

    public boolean editTextAndSave(String identifier, String value) {
        ConfigFragment configFragment = this.getConfigFragment();
        Editor editor = configFragment.edit();
        editor.text(identifier, value);
        return configFragment.save();
    }

    public boolean selectOptionAndSave(String identifier, String value) {
        ConfigFragment configFragment = this.getConfigFragment();
        configFragment.edit().select(identifier, value);
        return configFragment.save();
    }

    public Boolean editCheckboxAndSave(String identifier, Boolean value) {
        ConfigFragment configFragment = this.getConfigFragment();
        configFragment.edit().checkbox(identifier, value);
        return configFragment.save();
    }

    public Boolean isErrorShownInForm() {
        ByJQuery selector = ByJQuery.selector((String)"div.form-item-error-desc:visible");
        return this.isElementVisible((By)selector);
    }

    public void removeSecurityDomain(String name) {
        try {
            this.navigation.resetNavigation().step(SECURITY_DOMAIN, name).selectRow().invoke("Remove");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirmAndDismissReloadRequiredMessage();
    }

    public boolean isDomainPresent(String name) {
        return this.navigation.resetNavigation().step(SECURITY_DOMAIN, name).selectColumn().rowIsPresent(name, 60L, this.navigation);
    }

    public void selectModule(String name) {
        this.getResourceManager().selectByName(name);
    }

    public void addMappingModule(String name, String code, String type) {
        WizardWindow wizard = this.getResourceManager().addResource();
        Editor editor = wizard.getEditor();
        editor.text("name", name);
        editor.text("type", type);
        editor.text("code", code);
        wizard.finish();
    }
}

