/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.runtime;

import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.finder.Row;
import org.jboss.hal.testsuite.fragment.runtime.HostPropertiesWizard;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.openqa.selenium.By;

@Location(value="#hosts")
public class HostsPage
extends ConfigurationPage {
    private FinderNavigation navigation;
    private Row defaultHostRow;

    @Override
    public void navigate() {
        this.navigation = new FinderNavigation(this.browser, HostsPage.class).step("Browse Domain By", "Hosts").step("Host", ConfigUtils.getDefaultHost());
        this.defaultHostRow = this.navigation.selectRow();
    }

    public void viewServerConfiguration(String serverName) {
        this.navigation.resetNavigation().step("Server", serverName);
        this.navigation.selectRow().invoke("View");
        Application.waitUntilVisible();
    }

    public void viewDefaultHostProperties() {
        this.defaultHostRow.invoke("Properties");
    }

    public HostPropertiesWizard addProperty() {
        return this.getResourceManager().addResource(HostPropertiesWizard.class);
    }

    public boolean isRowPresent(String propertyName) {
        return this.getResourceManager().getResourceTable().getRowByText(0, propertyName) != null;
    }

    public boolean isErrorShown() {
        ByJQuery selector = ByJQuery.selector((String)"div.form-item-error-desc:visible");
        return this.isElementVisible((By)selector);
    }
}

