/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.jboss.hal.testsuite.creaper.ResourceVerifier;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.junit.Assert;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;

public final class ConfigChecker {
    private final OnlineManagementClient client;
    private final Address resourceAddress;
    private boolean saved;

    public ResourceVerifier verifyFormSaved() throws Exception {
        Assert.assertTrue((String)"Configuration should switch into read-only mode.", (boolean)this.saved);
        return new ResourceVerifier(this.resourceAddress, this.client);
    }

    public ResourceVerifier verifyFormNotSaved() throws Exception {
        Assert.assertFalse((String)"Configuration should NOT switch into read-only mode.", (boolean)this.saved);
        return new ResourceVerifier(this.resourceAddress, this.client);
    }

    private ConfigChecker(Builder builder) throws IOException, InterruptedException, TimeoutException {
        this.client = builder.client;
        this.resourceAddress = builder.resourceAddress;
        Object attrValue = this.getAttrValue(builder.attrValue, builder.inputType);
        this.edit(builder.config, builder.inputType, builder.identifier, attrValue);
    }

    private Object getAttrValue(Object attrValue, InputType inputType) {
        switch (inputType) {
            case TEXT: 
            case SELECT: {
                if (attrValue instanceof String) {
                    return attrValue;
                }
                if (attrValue instanceof Long) {
                    return String.valueOf((Long)attrValue);
                }
                if (attrValue instanceof Integer) {
                    return String.valueOf((Integer)attrValue);
                }
                throw new IllegalArgumentException(attrValue + " should be String, Integer or Long!");
            }
            case CHECKBOX: {
                if (attrValue instanceof Boolean) {
                    return attrValue;
                }
                throw new IllegalArgumentException(attrValue + " should be Boolean!");
            }
        }
        throw new IllegalArgumentException("Not yet supported inputType: " + (Object)((Object)inputType));
    }

    private void edit(ConfigFragment config, InputType inputType, String identifier, Object attrValue) throws IOException, InterruptedException, TimeoutException {
        switch (inputType) {
            case TEXT: {
                this.saved = config.editTextAndSave(identifier, (String)attrValue);
                break;
            }
            case CHECKBOX: {
                this.saved = config.editCheckboxAndSave(identifier, (Boolean)attrValue);
                break;
            }
            case SELECT: {
                this.saved = config.selectOptionAndSave(identifier, (String)attrValue);
            }
        }
        if (!this.saved) {
            config.cancel();
        }
    }

    public static class Builder {
        private final OnlineManagementClient client;
        private final Address resourceAddress;
        private ConfigFragment config;
        private InputType inputType;
        private String identifier;
        private Object attrValue;

        public Builder(OnlineManagementClient client, Address resourceAddress) {
            this.client = client;
            this.resourceAddress = resourceAddress;
        }

        public Builder configFragment(ConfigFragment config) {
            this.config = config;
            return this;
        }

        public ConfigChecker editAndSave(InputType inputType, String identifier, Object attrValue) throws IOException, InterruptedException, TimeoutException {
            if (this.config == null) {
                throw new IllegalStateException("ConfigFragment has to be set!");
            }
            this.inputType = inputType;
            this.identifier = identifier;
            this.attrValue = attrValue;
            return new ConfigChecker(this);
        }
    }

    public static enum InputType {
        TEXT,
        SELECT,
        CHECKBOX;

    }
}

