/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.creaper.command;

import java.io.IOException;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class RemoveSocketBinding
implements OnlineCommand {
    private final String socketBindingName;
    private final String socketBindingGroup;

    public RemoveSocketBinding(String socketBindingName, String socketBindingGroup) {
        if (socketBindingName == null) {
            throw new IllegalArgumentException("Name of the socket binding must be specified as non null value");
        }
        this.socketBindingName = socketBindingName;
        this.socketBindingGroup = socketBindingGroup;
    }

    public RemoveSocketBinding(String name) {
        this(name, null);
    }

    public void apply(OnlineCommandContext ctx) throws CommandFailedException, OperationException {
        Operations operations = new Operations(ctx.client);
        String socketBindingGroup = this.socketBindingGroup;
        if (socketBindingGroup == null) {
            socketBindingGroup = ctx.client.options().isDomain ? "full-sockets" : "standard-sockets";
        }
        Address socketBindingAddress = Address.of((String)"socket-binding-group", (String)socketBindingGroup).and("socket-binding", this.socketBindingName);
        try {
            operations.removeIfExists(socketBindingAddress);
        }
        catch (IOException e) {
            throw new CommandFailedException((Throwable)e);
        }
    }
}

