/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment;

import java.util.List;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class PagerFragment
extends BaseFragment {
    public static final String CLASS_NAME_PAGER = PropUtils.get("resourcepager.pager.class");
    public static final int IDX_FIRST_PAGE = 0;
    public static final int IDX_PREVIOUS_PAGE = 1;
    public static final int IDX_PAGER_INFO = 2;
    public static final int IDX_NEXT_PAGE = 3;
    public static final int IDX_LAST_PAGE = 4;
    public static final String PAGER_INFO_PATTERN = "(\\d+).+(\\d+).+(\\d+)";
    public static final int IDX_RECORDS_FROM = 1;
    public static final int IDX_RECORDS_TO = 2;
    public static final int IDX_RECORDS_TOTAL = 3;

    public int getTotalRecordsCount() {
        return this.getNthNumberFromInfo(3);
    }

    public int getCurrentFromNumber() {
        return this.getNthNumberFromInfo(1);
    }

    public int getCurrentToNumber() {
        return this.getNthNumberFromInfo(2);
    }

    public boolean goToNextPage() {
        return !this.isLastPage() && this.goToPageByClickingNthCell(3);
    }

    public boolean goToPreviousPage() {
        return !this.isFirstPage() && this.goToPageByClickingNthCell(1);
    }

    public boolean goToFirstPage() {
        return !this.isFirstPage() && this.goToPageByClickingNthCell(0);
    }

    public boolean goToLastPage() {
        return !this.isLastPage() && this.goToPageByClickingNthCell(4);
    }

    public boolean isFirstPage() {
        int currentFromNumber = this.getCurrentFromNumber();
        return currentFromNumber == 1 || currentFromNumber == 0;
    }

    public boolean isLastPage() {
        return this.getCurrentToNumber() == this.getTotalRecordsCount();
    }

    private WebElement getNthCell(int idx) {
        ByJQuery selector = ByJQuery.selector((String)"tr td");
        List tds = this.root.findElements((By)selector);
        if (tds.size() - 1 < idx) {
            return null;
        }
        return (WebElement)tds.get(idx);
    }

    private boolean goToPageByClickingNthCell(int idx) {
        WebElement td = this.getNthCell(idx);
        WebElement img = td.findElement(By.tagName((String)"img"));
        int previousFromNumber = this.getCurrentFromNumber();
        img.click();
        return this.getCurrentFromNumber() != previousFromNumber;
    }

    private int getNthNumberFromInfo(int idx) {
        WebElement pageInfoTd = this.getNthCell(2);
        String text = pageInfoTd.getText();
        if (text.matches(PAGER_INFO_PATTERN)) {
            return Integer.parseInt(text.replaceFirst(PAGER_INFO_PATTERN, "$" + idx));
        }
        return -1;
    }
}

