/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.config.patching;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchResultPanelFragment
extends BaseFragment {
    private static final Logger log = LoggerFactory.getLogger(PatchResultPanelFragment.class);
    public static final By SELECTOR = ByJQuery.selector((String)("." + PropUtils.get("runtime.patching.wizard.result.fragment.class") + ":visible"));
    private static final By ERROR_DETAILS_SELECTOR = By.className((String)PropUtils.get("runtime.patching.wizard.result.error.details.class"));
    private static final By ERROR_DETAILS_DISPLAYED_SELECTOR = ByJQuery.selector((String)("." + PropUtils.get("runtime.patching.wizard.result.error.details.class") + "." + PropUtils.get("runtime.patching.wizard.result.error.details.opened.class")));
    private static final By ERROR_DETAILS_HEADER_SELECTOR = By.className((String)PropUtils.get("runtime.patching.wizard.result.error.hideshowdetails.class"));
    private static final By ERROR_MESSAGE_SELECTOR = By.className((String)PropUtils.get("runtime.patching.wizard.result.error.message.class"));
    private static final By SUCCESS_MESSAGE_SELECTOR = By.className((String)PropUtils.get("runtime.patching.wizard.result.success.message.class"));

    public boolean isSuccessful() {
        try {
            Graphene.waitGui().until().element(ERROR_MESSAGE_SELECTOR).is().visible();
            return false;
        }
        catch (TimeoutException e) {
            return true;
        }
    }

    public void showErrorDetails() {
        if (!this.isErrorDetailsOpened()) {
            log.debug("Opening error details");
            this.root.findElement(ERROR_DETAILS_HEADER_SELECTOR).click();
        }
    }

    public void hideErrorDetails() {
        if (this.isErrorDetailsOpened()) {
            log.debug("Closing error details");
            this.root.findElement(ERROR_DETAILS_HEADER_SELECTOR).click();
        }
    }

    public boolean isErrorDetailsOpened() {
        return !this.root.findElements(ERROR_DETAILS_DISPLAYED_SELECTOR).isEmpty();
    }

    public String getPanelTitle() {
        return this.root.findElement(By.tagName((String)"h3")).getText();
    }

    public String getErrorMessage() {
        return this.root.findElement(ERROR_MESSAGE_SELECTOR).getText();
    }

    public String getMessage() {
        Graphene.waitModel().until().element(SUCCESS_MESSAGE_SELECTOR).is().visible();
        return this.root.findElement(SUCCESS_MESSAGE_SELECTOR).getText();
    }

    public String getErrorDetails() {
        this.showErrorDetails();
        return this.root.findElement(ERROR_DETAILS_SELECTOR).findElement(By.tagName((String)"pre")).getText();
    }
}

