/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.rhaccess;

import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.wait.IsNotElementBuilder;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class RHAccessFragment
extends BaseFragment {
    protected final By LOGIN_INPUT_SELECTOR = ByJQuery.selector((String)("input#" + PropUtils.get("rhaccess.login.id")));
    protected final By PASSWORD_INPUT_SELECTOR = ByJQuery.selector((String)("input#" + PropUtils.get("rhaccess.password.id")));
    protected final By LOGIN_SUBMIT_SELECTOR = ByJQuery.selector((String)("button." + PropUtils.get("rhaccess.login.submit.class")));
    protected final String RH_ACCESS_LOGIN = PropUtils.get("rhaccess.login");
    protected final String RH_ACCESS_PASSWORD = PropUtils.get("rhaccess.password");
    private final int LONG_SEARCH_TIMEOUT = 60;

    public boolean isAuthenticationRequested() {
        try {
            this.root.findElement(this.LOGIN_INPUT_SELECTOR);
            this.root.findElement(this.PASSWORD_INPUT_SELECTOR);
            return true;
        }
        catch (NoSuchElementException e) {
            return this.tryToInvokeLogIn();
        }
    }

    protected boolean tryToInvokeLogIn() {
        try {
            WebElement logInButton = this.findLogInButton();
            logInButton.click();
            this.waitLongUntilElementIs(this.LOGIN_INPUT_SELECTOR).present();
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    protected WebElement findLogInButton() {
        return this.root.findElement(By.partialLinkText((String)"Log In"));
    }

    public void authenticate() throws Exception {
        this.root.findElement(this.LOGIN_INPUT_SELECTOR).sendKeys(new CharSequence[]{this.RH_ACCESS_LOGIN});
        this.root.findElement(this.PASSWORD_INPUT_SELECTOR).sendKeys(new CharSequence[]{this.RH_ACCESS_PASSWORD});
        this.root.findElement(this.LOGIN_SUBMIT_SELECTOR).click();
    }

    protected IsNotElementBuilder<Void> waitLongUntilElementIs(By selector) {
        return this.waitLongUntilElementIs(selector, null);
    }

    protected IsNotElementBuilder<Void> waitLongUntilElementIs(By selector, SearchContext context) {
        if (context != null) {
            return Graphene.waitGui().withTimeout(60L, TimeUnit.SECONDS).until().element(context, selector).is();
        }
        return Graphene.waitGui().withTimeout(60L, TimeUnit.SECONDS).until().element(selector).is();
    }

    protected IsNotElementBuilder<Void> waitLongUntilElementIs(WebElement element) {
        return Graphene.waitGui().withTimeout(60L, TimeUnit.SECONDS).until().element(element).is();
    }

    public String getSelectValue(String selectName) {
        ByJQuery selector = ByJQuery.selector((String)("select[name=" + selectName + "]"));
        this.waitLongUntilElementIs((By)selector, (SearchContext)this.root).visible();
        WebElement selectElement = this.root.findElement((By)selector);
        Select select = new Select(selectElement);
        return select.getFirstSelectedOption().getText();
    }
}

