/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page;

import java.util.List;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.fragment.ConfigAreaFragment;
import org.jboss.hal.testsuite.fragment.WindowFragment;
import org.jboss.hal.testsuite.fragment.shared.modal.AdvancedSelectBox;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.fragment.shared.modal.WizardWindow;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableFragment;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableRowFragment;
import org.jboss.hal.testsuite.page.BasePage;
import org.jboss.hal.testsuite.page.config.DomainConfigEntryPoint;
import org.jboss.hal.testsuite.page.config.StandaloneConfigEntryPoint;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class ConfigPage
extends BasePage {
    public <T extends ConfigAreaFragment> T getConfig(Class<T> clazz) {
        WebElement configRoot = null;
        try {
            String cssClass = PropUtils.get("configarea.class");
            ByJQuery selector = ByJQuery.selector((String)("." + cssClass + ":visible"));
            configRoot = this.getContentRoot().findElement((By)selector);
        }
        catch (NoSuchElementException e) {
            List elements = this.getContentRoot().findElements(this.getConfigSelector());
            for (WebElement element : elements) {
                if (!element.isDisplayed()) continue;
                configRoot = element;
            }
        }
        ConfigAreaFragment config = (ConfigAreaFragment)Graphene.createPageFragment(clazz, configRoot);
        return (T)config;
    }

    private By getConfigSelector() {
        String selectionLabel = ".//div[contains(@class, 'content-group-label') and (contains(text(), 'Selection') or contains(text(), 'Details'))]";
        By selector = By.xpath((String)(selectionLabel + "/following::*[contains(@class, 'rhs-content-panel')]"));
        return selector;
    }

    public ConfigAreaFragment getConfig() {
        return this.getConfig(ConfigAreaFragment.class);
    }

    public <T extends WizardWindow> T addResource(Class<T> clazz, String label) {
        this.clickButton(label);
        T wizard = Console.withBrowser(this.browser).openedWizard(clazz);
        return wizard;
    }

    public void pickProfile(String label) {
        AdvancedSelectBox picker = this.getProfilePicker();
        picker.pickOption(label);
        Console.withBrowser(this.browser).waitUntilFinished();
    }

    public void pickHost(String label) {
        AdvancedSelectBox picker = this.getHostPicker();
        picker.pickOption(label);
        Console.withBrowser(this.browser).waitUntilFinished();
    }

    public AdvancedSelectBox getHostPicker() {
        return this.getContextPicker(PropUtils.get("navigation.context.host.id"));
    }

    public AdvancedSelectBox getProfilePicker() {
        return this.getContextPicker(PropUtils.get("navigation.context.profile.id"));
    }

    private AdvancedSelectBox getContextPicker(String label) {
        WebElement pickerRoot = this.getContextPickerRootByLabel(label);
        AdvancedSelectBox selectBox = (AdvancedSelectBox)Graphene.createPageFragment(AdvancedSelectBox.class, (WebElement)pickerRoot);
        return selectBox;
    }

    private WebElement getContextPickerRootByLabel(String label) {
        By selector = By.id((String)label);
        WebElement element = this.browser.findElement(selector);
        return element;
    }

    @Deprecated
    public ResourceTableFragment getResourceTable() {
        String cssClass = PropUtils.get("resourcetable.class");
        ByJQuery selector = ByJQuery.selector((String)("." + cssClass + ":visible"));
        WebElement tableRoot = this.getContentRoot().findElement((By)selector);
        ResourceTableFragment table = (ResourceTableFragment)Graphene.createPageFragment(ResourceTableFragment.class, (WebElement)tableRoot);
        return table;
    }

    @Deprecated
    public <T extends WizardWindow> T addResource(Class<T> clazz) {
        String label = PropUtils.get("config.shared.add.label");
        return this.addResource(clazz, label);
    }

    @Deprecated
    public WizardWindow addResource() {
        return this.addResource(WizardWindow.class);
    }

    @Deprecated
    public <T extends WindowFragment> T removeResource(String name, Class<T> clazz) {
        this.selectByName(name);
        String label = PropUtils.get("config.shared.remove.label");
        this.clickButton(label);
        T window = Console.withBrowser(this.browser).openedWindow(clazz);
        return window;
    }

    @Deprecated
    public ConfirmationWindow removeResource(String name) {
        return this.removeResource(name, ConfirmationWindow.class);
    }

    @Deprecated
    public ResourceTableRowFragment selectByName(String name) {
        return this.getResourceTable().selectRowByText(0, name);
    }

    @Deprecated
    public void viewByName(String name) {
        ResourceTableRowFragment row = this.selectByName(name);
        row.view();
    }

    public void navigate(String profile) {
        Graphene.goTo(DomainConfigEntryPoint.class);
        Console.withBrowser(this.browser).waitUntilLoaded();
        this.pickProfile(profile);
        this.navigate();
    }

    protected FinderNavigation getSubsystemNavigation(String subsystemName) {
        FinderNavigation navigation = ConfigUtils.isDomain() ? new FinderNavigation(this.browser, DomainConfigEntryPoint.class).step("Configuration", "Profiles").step("Profile", ConfigUtils.getDefaultProfile()) : new FinderNavigation(this.browser, StandaloneConfigEntryPoint.class).step("Configuration", "Subsystems");
        return navigation.step("Subsystem", subsystemName);
    }
}

