/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.arquillian.graphene.page.Location;
import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.Column;
import org.jboss.hal.testsuite.finder.Row;
import org.jboss.hal.testsuite.fragment.ConfigAreaFragment;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.WindowState;
import org.jboss.hal.testsuite.fragment.config.resourceadapters.ResourceAdapterWizard;
import org.jboss.hal.testsuite.fragment.config.resourceadapters.ResourceAdaptersConfigArea;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.util.Console;

@Location(value="#profile")
public class ResourceAdaptersPage
extends ConfigurationPage {
    private static final String RA_SUBSYSTEM_LABEL = "Resource Adapters";
    private static final String RA_COLUMN_LABEL = "Resource Adapter";

    public ResourceAdaptersConfigArea getConfigArea() {
        return this.getConfig(ResourceAdaptersConfigArea.class);
    }

    public ResourceAdaptersPage navigate2ra(String raName) {
        Row row = this.getSubsystemNavigation(RA_SUBSYSTEM_LABEL).step(RA_COLUMN_LABEL, raName).selectRow();
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        row.invoke("View");
        Application.waitUntilVisible();
        return this;
    }

    public ResourceAdapterWizard addResourceAdapter() {
        Column column = this.getSubsystemNavigation(RA_SUBSYSTEM_LABEL).step(RA_COLUMN_LABEL).selectColumn();
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        column.invoke("Add");
        return Console.withBrowser(this.browser).openedWizard(ResourceAdapterWizard.class);
    }

    public WindowState removeRa(String raName) {
        Row row = this.getSubsystemNavigation(RA_SUBSYSTEM_LABEL).step(RA_COLUMN_LABEL, raName).selectRow();
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        row.invoke("Remove");
        return Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirm();
    }

    public ConfigFragment switchConfigAreaTabTo(String tabLabel) {
        return this.getConfig(ConfigAreaFragment.class).switchTo(tabLabel);
    }
}

