/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.runtime;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.hal.testsuite.finder.Column;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.finder.Row;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.runtime.DeploymentContentRepositoryArea;
import org.jboss.hal.testsuite.fragment.runtime.DeploymentServerGroupArea;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;

@Location(value="#domain-deployments")
public class DomainDeploymentPage
extends ConfigurationPage {
    private static final By BACK_BUTTON = By.xpath((String)".//a[text()='Back']");
    private static final By CONTENT = By.className((String)PropUtils.get("page.content.gwt-layoutpanel"));

    public DeploymentContentRepositoryArea switchToContentRepository() {
        this.switchTab("Content Repository");
        return this.getDeploymentContent(DeploymentContentRepositoryArea.class);
    }

    public DeploymentServerGroupArea switchToServerGroup(String serverGroup) {
        this.switchTab("Server Groups");
        WebElement backAnchor = this.getContentRoot().findElement(BACK_BUTTON);
        if (backAnchor.isDisplayed()) {
            backAnchor.click();
        }
        this.getResourceManager().viewByName(serverGroup);
        return this.getDeploymentContent(DeploymentServerGroupArea.class);
    }

    public <T extends BaseFragment> T getDeploymentContent(Class<T> clazz) {
        WebElement content = this.getContentRoot().findElement(CONTENT);
        return (T)((BaseFragment)Graphene.createPageFragment(clazz, (WebElement)content));
    }

    public DeploymentContentRepositoryArea getDeploymentContent() {
        WebElement content = this.getContentRoot().findElement(CONTENT);
        return (DeploymentContentRepositoryArea)Graphene.createPageFragment(DeploymentContentRepositoryArea.class, (WebElement)content);
    }

    public void unassign() {
        this.option("Unassign");
        try {
            Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirm();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public boolean checkAssignDeploymentNameInAssignContent(String assignName) {
        WebElement editPanel = this.browser.findElement(By.className((String)"default-window-content"));
        String contentText = editPanel.findElement(By.className((String)"gwt-Label")).getText();
        editPanel.findElement((By)ByJQuery.selector((String)"button:contains(Cancel)")).click();
        return contentText.contains(assignName);
    }

    public Row navigateToRowInServerGroup(String groupName, String deploymentName) {
        Row row = new FinderNavigation(this.browser, this.getClass()).step("Browse By", "Server Groups").step("Server Group", groupName).step("Deployment", deploymentName).selectRow();
        Console.withBrowser(this.browser).waitUntilLoaded();
        return row;
    }

    public Row navigateToRowInUnassignedContent(String deploymentName) {
        Row row = new FinderNavigation(this.browser, this.getClass()).step("Browse By", "Unassigned Content").step("Unassigned", deploymentName).selectRow();
        Console.withBrowser(this.browser).waitUntilLoaded();
        return row;
    }

    public Column navigateToColumnInContentRepository() {
        Column column = new FinderNavigation(this.browser, this.getClass()).step("Browse By", "Content Repository").step("All Content").selectColumn();
        Console.withBrowser(this.browser).waitUntilLoaded();
        return column;
    }

    public Column navigateToDeploymentColumnInServerGroup(String groupName) {
        Column column = new FinderNavigation(this.browser, this.getClass()).step("Browse By", "Server Groups").step("Server Group", groupName).step("Deployment").selectColumn();
        Console.withBrowser(this.browser).waitUntilLoaded();
        return column;
    }
}

