/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.hal.testsuite.fragment.shared.modal.LogConfirmDownloadWindow;
import org.jboss.hal.testsuite.page.RuntimePage;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;

@Location(value="#logfiles")
public class LogViewerPage
extends RuntimePage {
    public static final String MAIN_TAB = PropUtils.get("logviewer.tab.main.label");
    public static final String CLOSE_TAB = PropUtils.get("content.tab.close.class");
    public static final String REMOVE = PropUtils.get("remove.icon.class");
    public static final String VIEW_BUTTON = PropUtils.get("logviewer.btn.view.id");

    public void switchToFileList() {
        this.switchTab(MAIN_TAB);
    }

    public void selectLogFile(String name) {
        this.getResourceManager().selectByName(name);
    }

    public void viewFile(String name) {
        this.selectLogFile(name);
        this.clickButton(VIEW_BUTTON);
        this.waitUntilTabIsPresent(name);
    }

    public LogConfirmDownloadWindow viewLargeFile(String name) {
        this.selectLogFile(name);
        this.clickButton(VIEW_BUTTON);
        return Console.withBrowser(this.browser).openedWindow(LogConfirmDownloadWindow.class);
    }

    public String getLogConent() {
        By selector = By.className((String)PropUtils.get("logviewer.content.text.class"));
        WebElement content = this.getContentRoot().findElement(selector);
        return content.getText();
    }

    public boolean closeFile(String name) {
        Map<String, WebElement> map = this.openedFileTabsMap();
        WebElement tab = map.get(name);
        ByJQuery selector = ByJQuery.selector((String)("." + REMOVE + "." + CLOSE_TAB + ":visible"));
        WebElement close = tab.findElement((By)selector);
        close.click();
        try {
            this.waitUntilTabIsNotPresent(name);
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public Set<String> openedFileNames() {
        Map<String, WebElement> map = this.openedFileTabsMap();
        return map.keySet();
    }

    private List<WebElement> openedFileTabs() {
        By selector = By.className((String)"hal-TabLayout-tab");
        List elements = this.getContentRoot().findElements(selector);
        if (elements.size() < 2) {
            return Collections.emptyList();
        }
        return elements;
    }

    private Map<String, WebElement> openedFileTabsMap() {
        List<WebElement> tabs = this.openedFileTabs();
        HashMap<String, WebElement> map = new HashMap<String, WebElement>();
        for (int i = 1; i < tabs.size(); ++i) {
            WebElement elm = tabs.get(i);
            map.put(elm.getText().toLowerCase(), elm);
        }
        return map;
    }
}

