/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.creaper.command;

import java.io.File;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;

public class DeployCommand
implements OnlineCommand {
    private final String path;
    private final boolean toAllGroups;
    private final String particularGroup;
    private final String deploymentName;
    private final String runtimeName;
    private final boolean disabled;
    private final boolean unmanaged;

    private DeployCommand(Builder builder) {
        this.path = builder.path;
        this.toAllGroups = builder.toAllGroups;
        this.particularGroup = builder.particularGroup;
        this.deploymentName = builder.deploymentName;
        this.runtimeName = builder.runtimeName;
        this.disabled = builder.disabled;
        this.unmanaged = builder.unmanaged;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        StringBuilder cmd = new StringBuilder("deploy ").append(this.path);
        if (ctx.options.isDomain && !this.disabled) {
            if (this.toAllGroups) {
                cmd.append(" --all-server-groups");
            } else {
                cmd.append(" --server-groups=").append(this.particularGroup);
            }
        }
        if (this.deploymentName != null) {
            cmd.append(" --name=").append(this.deploymentName);
        }
        if (this.runtimeName != null) {
            cmd.append(" --runtime-name=").append(this.runtimeName);
        }
        if (this.disabled) {
            cmd.append(" --disabled");
        }
        if (this.unmanaged) {
            cmd.append(" --unmanaged");
        }
        ctx.client.executeCli(cmd.toString());
    }

    public static final class Builder {
        private final String path;
        private boolean toAllGroups = false;
        private String particularGroup;
        private String deploymentName;
        private String runtimeName;
        private boolean disabled = false;
        private boolean unmanaged;

        public Builder(String path) {
            if (!new File(path).exists()) {
                throw new IllegalArgumentException(path + " doesn't exist!");
            }
            this.path = path;
        }

        public Builder(File file) {
            if (!file.exists()) {
                throw new IllegalArgumentException(file + " doesn't exist!");
            }
            this.path = file.getAbsolutePath();
        }

        public Builder toAllGroups() {
            this.toAllGroups = true;
            return this;
        }

        public Builder particularGroup(String groupName) {
            if (groupName == null || groupName.trim().isEmpty()) {
                throw new IllegalArgumentException("Group name should be neither empty nor whitespace!");
            }
            this.particularGroup = groupName;
            return this;
        }

        public Builder name(String deploymentName) {
            if (deploymentName == null || deploymentName.trim().isEmpty()) {
                throw new IllegalArgumentException("Deployment name should be neither empty nor whitespace!");
            }
            this.deploymentName = deploymentName;
            return this;
        }

        public Builder runtimeName(String runtimeName) {
            if (runtimeName == null || runtimeName.trim().isEmpty()) {
                throw new IllegalArgumentException("Runtime name should be neither empty nor whitespace!");
            }
            this.runtimeName = runtimeName;
            return this;
        }

        public Builder disabled() {
            this.disabled = true;
            return this;
        }

        public Builder unmanaged() {
            this.unmanaged = true;
            return this;
        }

        public DeployCommand build() {
            if (ConfigUtils.isDomain()) {
                if (!this.disabled && this.toAllGroups == (this.particularGroup != null)) {
                    throw new IllegalArgumentException("In domain mode either nonempty particularGroup XOR toAllGroups should be specified!");
                }
            } else if (this.toAllGroups || this.particularGroup != null) {
                throw new IllegalArgumentException("In standalone mode neither particularGroup nor toAllGroups=true should be specified!");
            }
            return new DeployCommand(this);
        }
    }
}

