/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.dmr;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jboss.dmr.ModelNode;
import org.jboss.hal.testsuite.dmr.ResourceAddress;
import org.jboss.hal.testsuite.dmr.StatementContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressTemplate {
    private static final Logger log = LoggerFactory.getLogger(AddressTemplate.class);
    private final String template;
    private final LinkedList<Token> tokens;

    public static AddressTemplate of(String template) {
        return new AddressTemplate(template);
    }

    private AddressTemplate(String template) {
        assert (template != null) : "template must not be null";
        this.tokens = this.parse(template);
        this.template = this.join(this.tokens);
    }

    private LinkedList<Token> parse(String template) {
        LinkedList<Token> tokens = new LinkedList<Token>();
        if (template.equals("/")) {
            return tokens;
        }
        StringTokenizer tok = new StringTokenizer(template, "/");
        while (tok.hasMoreTokens()) {
            String nextToken = tok.nextToken();
            if (nextToken.contains("=")) {
                String[] split = nextToken.split("=");
                tokens.add(new Token(split[0], split[1]));
                continue;
            }
            tokens.add(new Token(nextToken));
        }
        return tokens;
    }

    private String join(LinkedList<Token> tokens) {
        return Joiner.on((char)'/').join(tokens);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddressTemplate)) {
            return false;
        }
        AddressTemplate that = (AddressTemplate)o;
        return this.template.equals(that.template);
    }

    public int hashCode() {
        return this.template.hashCode();
    }

    public String toString() {
        return this.getTemplate();
    }

    public AddressTemplate append(String template) {
        String slashTemplate = template.startsWith("/") ? template : "/" + template;
        return AddressTemplate.of(this.template + slashTemplate);
    }

    public AddressTemplate subTemplate(int fromIndex, int toIndex) {
        LinkedList<Token> subTokens = new LinkedList<Token>();
        subTokens.addAll(this.tokens.subList(fromIndex, toIndex));
        return AddressTemplate.of(this.join(subTokens));
    }

    public AddressTemplate replaceWildcards(String wildcard, String ... wildcards) {
        ArrayList<String> allWildcards = new ArrayList<String>();
        allWildcards.add(wildcard);
        if (wildcards != null) {
            allWildcards.addAll(Arrays.asList(wildcards));
        }
        LinkedList<Token> replacedTokens = new LinkedList<Token>();
        Iterator wi = allWildcards.iterator();
        for (Token token : this.tokens) {
            if (wi.hasNext() && token.hasKey() && "*".equals(token.getValue())) {
                replacedTokens.add(new Token(token.getKey(), (String)wi.next()));
                continue;
            }
            replacedTokens.add(new Token(token.key, token.value));
        }
        return AddressTemplate.of(this.join(replacedTokens));
    }

    public String getResourceType() {
        if (!this.tokens.isEmpty() && this.tokens.getLast().hasKey()) {
            return this.tokens.getLast().getKey();
        }
        return null;
    }

    public String getTemplate() {
        return this.template;
    }

    public ResourceAddress resolve(StatementContext context, String ... wildcards) {
        int wildcardCount = 0;
        ModelNode model = new ModelNode();
        Memory<String[]> tupleMemory = new Memory<String[]>();
        Memory<String> valueMemory = new Memory<String>();
        for (Token token : this.tokens) {
            String resolvedValue;
            String resolvedKey;
            if (!token.hasKey()) {
                String[] resolvedValue2;
                String tokenRef = token.getValue();
                if (tokenRef.startsWith("{")) {
                    if (!tupleMemory.contains(tokenRef = tokenRef.substring(1, tokenRef.length() - 1))) {
                        tupleMemory.memorize(tokenRef, context.collectTuples(tokenRef));
                    }
                    resolvedValue2 = (String[])tupleMemory.next(tokenRef);
                } else {
                    assert (tokenRef.contains("=")) : "Invalid token expression " + tokenRef;
                    resolvedValue2 = tokenRef.split("=");
                }
                if (resolvedValue2 == null) {
                    log.warn("Suppress token expression '{}'. It cannot be resolved", (Object)tokenRef);
                    continue;
                }
                model.add(resolvedValue2[0], resolvedValue2[1]);
                continue;
            }
            String keyRef = token.getKey();
            String valueRef = token.getValue();
            if (keyRef.startsWith("{")) {
                if (!valueMemory.contains(keyRef = keyRef.substring(1, keyRef.length() - 1))) {
                    valueMemory.memorize(keyRef, context.collect(keyRef));
                }
                resolvedKey = (String)valueMemory.next(keyRef);
            } else {
                resolvedKey = keyRef;
            }
            if (valueRef.startsWith("{")) {
                if (!valueMemory.contains(valueRef = valueRef.substring(1, valueRef.length() - 1))) {
                    valueMemory.memorize(valueRef, context.collect(valueRef));
                }
                resolvedValue = (String)valueMemory.next(valueRef);
            } else {
                resolvedValue = valueRef;
            }
            if (resolvedKey == null) {
                resolvedKey = "_blank";
            }
            if (resolvedValue == null) {
                resolvedValue = "_blank";
            }
            String addressValue = resolvedValue;
            if ("*".equals(resolvedValue) && wildcards != null && wildcards.length > 0 && wildcardCount < wildcards.length) {
                addressValue = wildcards[wildcardCount];
                ++wildcardCount;
            }
            model.add(resolvedKey, addressValue);
        }
        return new ResourceAddress(model);
    }

    private static class Memory<T> {
        Map<String, LinkedList<T>> values = new HashMap<String, LinkedList<T>>();
        Map<String, Integer> indexes = new HashMap<String, Integer>();

        private Memory() {
        }

        boolean contains(String key) {
            return this.values.containsKey(key);
        }

        void memorize(String key, LinkedList<T> resolved) {
            int startIdx = resolved.isEmpty() ? 0 : resolved.size() - 1;
            this.values.put(key, resolved);
            this.indexes.put(key, startIdx);
        }

        T next(String key) {
            T result = null;
            LinkedList<T> items = this.values.get(key);
            Integer idx = this.indexes.get(key);
            if (!items.isEmpty() && idx >= 0) {
                result = items.get(idx);
                idx = idx - 1;
                this.indexes.put(key, idx);
            }
            return result;
        }
    }

    private static class StringTokenizer {
        private final String delim;
        private final String s;
        private final int len;
        private int pos;
        private String next;

        StringTokenizer(String s, String delim) {
            this.s = s;
            this.delim = delim;
            this.len = s.length();
        }

        String nextToken() {
            if (!this.hasMoreTokens()) {
                throw new NoSuchElementException();
            }
            String result = this.next;
            this.next = null;
            return result;
        }

        boolean hasMoreTokens() {
            if (this.next != null) {
                return true;
            }
            while (this.pos < this.len && this.delim.indexOf(this.s.charAt(this.pos)) != -1) {
                ++this.pos;
            }
            if (this.pos >= this.len) {
                return false;
            }
            int p0 = this.pos++;
            while (this.pos < this.len && this.delim.indexOf(this.s.charAt(this.pos)) == -1) {
                ++this.pos;
            }
            this.next = this.s.substring(p0, this.pos++);
            return true;
        }
    }

    private static class Token {
        String key;
        String value;

        Token(String key, String value) {
            this.key = key;
            this.value = value;
        }

        Token(String value) {
            this.key = null;
            this.value = value;
        }

        boolean hasKey() {
            return this.key != null;
        }

        String getKey() {
            return this.key;
        }

        String getValue() {
            return this.value;
        }

        public String toString() {
            return this.hasKey() ? this.key + "=" + this.value : this.value;
        }
    }
}

