/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.dmr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class ModelNodeGenerator {
    public ModelNode createObjectNodeWithPropertyChild(String firstChildPropertyKey, String firstChildPropertyValue) {
        HashMap<String, ModelNode> propertyMap = new HashMap<String, ModelNode>(1);
        propertyMap.put(firstChildPropertyKey, new ModelNode(firstChildPropertyValue));
        return this.createObjectNodeWithPropertyChildren(propertyMap);
    }

    public ModelNode createObjectNodeWithPropertyChildren(Map<String, ModelNode> childPropertiesMap) {
        ModelNode parent = new ModelNode();
        childPropertiesMap.forEach((propertyKey, propertyValue) -> parent.get(propertyKey).set(propertyValue));
        return parent;
    }

    public static final class ModelNodeListBuilder {
        private List<ModelNode> nodeList = new ArrayList<ModelNode>();
        private boolean isEmpty = false;

        public ModelNodeListBuilder() {
        }

        public ModelNodeListBuilder(ModelNode node) {
            this.nodeList.add(node);
        }

        public ModelNodeListBuilder empty() {
            this.isEmpty = true;
            return this;
        }

        public ModelNodeListBuilder addNode(ModelNode node) {
            this.nodeList.add(node);
            return this;
        }

        public ModelNodeListBuilder addAll(String ... values) {
            for (String value : values) {
                this.nodeList.add(new ModelNode(value));
            }
            return this;
        }

        public ModelNode build() {
            ModelNode parent = new ModelNode();
            if (this.isEmpty) {
                parent.add();
                parent.remove(0);
                return parent;
            }
            if (this.nodeList.isEmpty()) {
                throw new IllegalStateException("No child node yet set! You have to either set list as empty or add any ModelNode first!");
            }
            this.nodeList.forEach(item -> parent.add(item));
            return parent;
        }
    }

    public static final class ModelNodePropertiesBuilder {
        private Map<String, ModelNode> propertyMap = new LinkedHashMap<String, ModelNode>();

        public ModelNodePropertiesBuilder addProperty(String key, ModelNode value) {
            this.propertyMap.put(key, value);
            return this;
        }

        public ModelNodePropertiesBuilder addProperty(String key, String value) {
            return this.addProperty(key, new ModelNode(value));
        }

        public ModelNodePropertiesBuilder addUndefinedProperty(String key) {
            return this.addProperty(key, new ModelNode());
        }

        public ModelNode build() {
            if (this.propertyMap.isEmpty()) {
                throw new IllegalStateException("You have to add any property first!");
            }
            return new ModelNodeGenerator().createObjectNodeWithPropertyChildren(this.propertyMap);
        }
    }
}

