/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment;

import java.util.List;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.shared.util.ResourceManager;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class ConfigAreaFragment
extends BaseFragment {
    public WebElement getTabByLabel(String label) {
        String tabClass = PropUtils.get("configarea.tab.class");
        ByJQuery selector = ByJQuery.selector((String)("." + tabClass + ":contains('" + label + "')"));
        List items = this.root.findElements((By)selector);
        for (WebElement item : items) {
            if (!item.isDisplayed() || !item.getText().equals(label)) continue;
            return item;
        }
        throw new NoSuchElementException(selector.toString());
    }

    public void clickTabByLabel(String label) {
        WebElement item = this.getTabByLabel(label);
        item.click();
        String selectedTabClass = PropUtils.get("configarea.tab.selected.class");
        Graphene.waitGui().until().element(item).attribute("class").contains(selectedTabClass);
    }

    public <T extends ConfigFragment> T switchTo(String label, Class<T> clazz) {
        this.clickTabByLabel(label);
        By selector = By.className((String)PropUtils.get("configarea.content.class"));
        WebElement contentRoot = this.root.findElement(selector);
        ConfigFragment content = (ConfigFragment)Graphene.createPageFragment(clazz, (WebElement)contentRoot);
        return (T)content;
    }

    public ConfigFragment switchTo(String label) {
        return this.switchTo(label, ConfigFragment.class);
    }

    public ResourceManager getResourceManager() {
        return (ResourceManager)Graphene.createPageFragment(ResourceManager.class, (WebElement)this.root);
    }
}

