/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.shared.table;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.PagerFragment;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableFragment;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableRowFragment;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericResourceTableFragment<T extends ResourceTableRowFragment>
extends BaseFragment {
    private static final Logger log = LoggerFactory.getLogger(ResourceTableFragment.class);
    public static final By SELECTOR = ByJQuery.selector((String)("." + PropUtils.get("resourcetable.class") + ":visible"));
    public static final By SELECTOR_PAGER = ByJQuery.selector((String)("." + PagerFragment.CLASS_NAME_PAGER + ":visible"));
    private PagerFragment pager = null;
    private Class<T> type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    public T getRow(int index) {
        T row = null;
        if (this.hasPager()) {
            this.getPager().goToFirstPage();
            do {
                if (this.getPager().getCurrentFromNumber() <= index + 1 && index + 1 <= this.getPager().getCurrentToNumber()) {
                    row = this.getVisibleRow(index - this.getPager().getCurrentFromNumber());
                    break;
                }
                log.trace("Trying to move to next page");
            } while (this.getPager().goToNextPage());
        } else {
            row = this.getVisibleRow(index);
        }
        if (row != null) {
            log.debug("Row with index {} found.", (Object)index);
        } else {
            log.debug("No row with index {} at this table.", (Object)index);
        }
        return row;
    }

    public T getVisibleRow(int index) {
        List<WebElement> rowElements = this.getRowElements();
        if (0 <= index && index < rowElements.size()) {
            return (T)((ResourceTableRowFragment)Graphene.createPageFragment(this.type, (WebElement)rowElements.get(index)));
        }
        return null;
    }

    public T getLastRow() {
        List<WebElement> rowElements;
        if (this.hasPager()) {
            this.getPager().goToLastPage();
        }
        if (!(rowElements = this.getRowElements()).isEmpty()) {
            WebElement rowRoot = rowElements.get(rowElements.size() - 1);
            return (T)((ResourceTableRowFragment)Graphene.createPageFragment(this.type, (WebElement)rowRoot));
        }
        return null;
    }

    public List<T> getVisibleRows() {
        List<WebElement> rowElements = this.getRowElements();
        ArrayList<Object> rows = new ArrayList<Object>(rowElements.size());
        for (WebElement e : rowElements) {
            rows.add(Graphene.createPageFragment(this.type, (WebElement)e));
        }
        return rows;
    }

    public List<T> getAllRows() {
        ArrayList<T> rows = new ArrayList<T>();
        if (!this.hasPager()) {
            return this.getVisibleRows();
        }
        this.getPager().goToFirstPage();
        do {
            log.trace("Adding all visible rows to all rows list");
            rows.addAll(this.getVisibleRows());
        } while (this.getPager().goToNextPage());
        return rows;
    }

    public T getRowByText(int col, String text) {
        ResourceTableRowFragment row = null;
        if (this.hasPager()) {
            this.getPager().goToFirstPage();
            do {
                List<T> rowsWithText;
                if (!(rowsWithText = this.findVisibleRowsByCellValueAtIndex(col, text)).isEmpty()) {
                    log.debug("Row with text <{}> at column {} found.", (Object)text, (Object)col);
                    row = (ResourceTableRowFragment)rowsWithText.get(0);
                    break;
                }
                log.debug("Row with text <{}> at column {} not found on this page of table.", (Object)text, (Object)col);
                log.debug("Trying to move to next page");
            } while (this.getPager().goToNextPage());
        } else {
            List<T> rowsWithText = this.findVisibleRowsByCellValueAtIndex(col, text);
            if (!rowsWithText.isEmpty()) {
                row = (ResourceTableRowFragment)rowsWithText.get(0);
            }
        }
        if (row != null) {
            log.debug("Row with text <{}> at column {} found.", (Object)text, (Object)col);
        } else {
            log.debug("Row with text <{}> at column {} not found at this table.", (Object)text, (Object)col);
        }
        return (T)row;
    }

    public T selectRowByText(int col, String text) {
        T row = this.getRowByText(col, text);
        if (row != null) {
            ((ResourceTableRowFragment)row).click();
            Graphene.waitModel().withTimeout(1500L, TimeUnit.MILLISECONDS).until().element(((BaseFragment)row).getRoot()).attribute("class").contains("cellTableSelectedRow");
        }
        return row;
    }

    public boolean hasPager() {
        return !this.root.findElements(SELECTOR_PAGER).isEmpty();
    }

    public PagerFragment getPager() {
        if (this.pager == null && this.hasPager()) {
            log.debug("Creating pager fragment");
            WebElement pagerElement = this.root.findElement(SELECTOR_PAGER);
            this.pager = (PagerFragment)Graphene.createPageFragment(PagerFragment.class, (WebElement)pagerElement);
        }
        return this.pager;
    }

    private List<WebElement> getRowElements() {
        ByJQuery selector = new ByJQuery("tr.cellTableEvenRow, tr.cellTableOddRow");
        List rowElements = this.getTableRoot().findElements((By)selector);
        if (rowElements.isEmpty()) {
            log.warn("Table is empty");
        }
        return rowElements;
    }

    private List<T> findVisibleRowsByCellValueAtIndex(int columnIndex, String cellValue) {
        List rows = this.getVisibleRows().stream().filter(item -> item.getCellValue(columnIndex).equals(cellValue)).collect(Collectors.toList());
        log.debug("Found {} rows with text '{}' at column {}", new Object[]{rows.size(), cellValue, columnIndex});
        return rows;
    }

    public List<String> getTextInColumn(int col) {
        ArrayList<String> values = new ArrayList<String>();
        List<T> rows = this.getAllRows();
        values.addAll(rows.stream().map(row -> row.getCellValue(col)).collect(Collectors.toList()));
        return values;
    }

    private WebElement getTableRoot() {
        try {
            return this.getRoot().findElement(SELECTOR);
        }
        catch (NoSuchElementException ignored) {
            return this.getRoot();
        }
    }
}

