/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.ConfigAreaFragment;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.fragment.shared.modal.WizardWindow;
import org.jboss.hal.testsuite.page.ConfigPage;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;

public class ConfigurationPage
extends ConfigPage {
    @Override
    public ConfigurationPage selectMenu(String label) {
        return (ConfigurationPage)super.selectMenu(label);
    }

    public <T extends WizardWindow> T add(Class<T> clazz) {
        return this.getResourceManager().addResource(clazz);
    }

    public void remove() {
        this.option("Remove");
        try {
            Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirm();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void option(String optionLabel) {
        String menuClass = PropUtils.get("options.dropdown.class");
        String menuItemClass = PropUtils.get("options.menu.item.class");
        ByJQuery menuSelector = ByJQuery.selector((String)("button." + menuClass + ":visible"));
        ByJQuery optionSelector = ByJQuery.selector((String)("td." + menuItemClass + ":contains('" + optionLabel + "'):visible"));
        this.getContentRoot().findElement((By)menuSelector).click();
        Graphene.waitModel().until().element((By)optionSelector).is().present();
        this.browser.findElement((By)optionSelector).click();
    }

    public ConfigurationPage view(String label) {
        this.selectMenu(label);
        this.clickButton("View");
        return this;
    }

    @Override
    public ConfigAreaFragment getConfig() {
        String layoutClass = PropUtils.get("configarea.layout.class");
        String viewPanelClass = PropUtils.get("configarea.view.panel.class");
        ByJQuery selector = ByJQuery.selector((String)("." + layoutClass + ":visible:has(table." + viewPanelClass + ")"));
        WebElement root = this.browser.findElement((By)selector);
        return (ConfigAreaFragment)Graphene.createPageFragment(ConfigAreaFragment.class, (WebElement)root);
    }

    public boolean isElementVisible(By selector) {
        try {
            Graphene.waitAjax().until().element(selector).is().visible();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

