/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.config.socketbindings.InboundSocketBindingFragment;
import org.jboss.hal.testsuite.page.ConfigPage;
import org.jboss.hal.testsuite.page.Navigatable;
import org.jboss.hal.testsuite.page.config.StandaloneConfigEntryPoint;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@Location(value="#socket-bindings;name=standard-sockets")
public class StandardSocketBindingsPage
extends ConfigPage
implements Navigatable {
    private static final By CONTENT_ROOT = ByJQuery.selector((String)("." + PropUtils.get("page.content.rhs.class") + ":visible"));

    public InboundSocketBindingFragment switchToInbound() {
        return this.switchTo(InboundSocketBindingFragment.class, "Inbound");
    }

    public ConfigFragment switchToOutboundRemote() {
        return this.switchTo("Outbound Remote");
    }

    public ConfigFragment switchToOutboundLocal() {
        return this.switchTo("Outbound Local");
    }

    private ConfigFragment switchTo(String label) {
        return this.switchTo(ConfigFragment.class, label);
    }

    private <T extends ConfigFragment> T switchTo(Class<T> clazz, String label) {
        this.switchSubTab(label);
        WebElement root = this.getContentRoot().findElement(CONTENT_ROOT);
        return (T)((ConfigFragment)Graphene.createPageFragment(clazz, (WebElement)root));
    }

    @Override
    public void navigate() {
        new FinderNavigation(this.browser, StandaloneConfigEntryPoint.class).step("Configuration", "Socket Binding").selectRow().invoke("View");
        Application.waitUntilVisible();
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        this.getResourceManager().viewByName("standard-sockets");
        Console.withBrowser(this.browser).waitUntilLoaded().waitForContent();
    }
}

