/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.Column;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.finder.Row;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.runtime.DeploymentContentRepositoryArea;
import org.jboss.hal.testsuite.fragment.runtime.DeploymentServerGroupArea;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.page.runtime.DomainDeploymentEntryPoint;
import org.jboss.hal.testsuite.page.runtime.StandaloneDeploymentEntryPoint;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class DeploymentsPage
extends ConfigurationPage {
    private static final By BACK_BUTTON = By.xpath((String)".//a[text()='Back']");
    private static final By CONTENT = By.className((String)PropUtils.get("page.content.gwt-layoutpanel"));
    private static final String CONTENT_TABLE_ROW = "table:contains('Data') tr.form-attribute-row";

    private void checkIfServerIsRunningInExpectedMode(ServerMode expectedServerMode) {
        if (expectedServerMode == ServerMode.DOMAIN && !ConfigUtils.isDomain()) {
            throw new IllegalStateException("This method can be used only in domain mode!");
        }
        if (expectedServerMode == ServerMode.STANDALONE && ConfigUtils.isDomain()) {
            throw new IllegalStateException("This method can be used only in standalone mode!");
        }
    }

    public DeploymentContentRepositoryArea switchToContentRepository() {
        this.switchTab("Content Repository");
        return this.getDeploymentContent(DeploymentContentRepositoryArea.class);
    }

    public DeploymentServerGroupArea switchToServerGroup(String serverGroup) {
        this.switchTab("Server Groups");
        WebElement backAnchor = this.getContentRoot().findElement(BACK_BUTTON);
        if (backAnchor.isDisplayed()) {
            backAnchor.click();
        }
        this.getResourceManager().viewByName(serverGroup);
        return this.getDeploymentContent(DeploymentServerGroupArea.class);
    }

    public <T extends BaseFragment> T getDeploymentContent(Class<T> clazz) {
        WebElement content = this.getContentRoot().findElement(CONTENT);
        return (T)((BaseFragment)Graphene.createPageFragment(clazz, (WebElement)content));
    }

    public DeploymentContentRepositoryArea getDeploymentContent() {
        WebElement content = this.getContentRoot().findElement(CONTENT);
        return (DeploymentContentRepositoryArea)Graphene.createPageFragment(DeploymentContentRepositoryArea.class, (WebElement)content);
    }

    public boolean checkAssignDeploymentNameInAssignContent(String assignName) {
        WebElement editPanel = this.browser.findElement(By.className((String)"default-window-content"));
        String contentText = editPanel.findElement(By.className((String)"gwt-Label")).getText();
        editPanel.findElement((By)ByJQuery.selector((String)"button:contains(Cancel)")).click();
        return contentText.contains(assignName);
    }

    public Row navigateToDeploymentInStandalone(String deploymentName) {
        this.checkIfServerIsRunningInExpectedMode(ServerMode.STANDALONE);
        return new FinderNavigation(this.browser, StandaloneDeploymentEntryPoint.class).step("Deployment", deploymentName).selectRow();
    }

    public Row navigateToRowInServerGroup(String groupName, String deploymentName) {
        this.checkIfServerIsRunningInExpectedMode(ServerMode.DOMAIN);
        Row row = new FinderNavigation(this.browser, DomainDeploymentEntryPoint.class).step("Browse By", "Server Groups").step("Server Group", groupName).step("Deployment", deploymentName).selectRow();
        Console.withBrowser(this.browser).waitUntilLoaded();
        return row;
    }

    public Row navigateToRowInUnassignedContent(String deploymentName) {
        this.checkIfServerIsRunningInExpectedMode(ServerMode.DOMAIN);
        Row row = new FinderNavigation(this.browser, DomainDeploymentEntryPoint.class).step("Browse By", "Unassigned Content").step("Unassigned", deploymentName).selectRow();
        Console.withBrowser(this.browser).waitUntilLoaded();
        return row;
    }

    public Column navigateToColumnInContentRepository() {
        this.checkIfServerIsRunningInExpectedMode(ServerMode.DOMAIN);
        Column column = new FinderNavigation(this.browser, DomainDeploymentEntryPoint.class).step("Browse By", "Content Repository").step("All Content").selectColumn();
        Console.withBrowser(this.browser).waitUntilLoaded();
        return column;
    }

    public Column navigateToDeploymentColumnInServerGroup(String groupName) {
        this.checkIfServerIsRunningInExpectedMode(ServerMode.DOMAIN);
        Column column = new FinderNavigation(this.browser, DomainDeploymentEntryPoint.class).step("Browse By", "Server Groups").step("Server Group", groupName).step("Deployment").selectColumn();
        Console.withBrowser(this.browser).waitUntilLoaded();
        return column;
    }

    public List<String> getDeploymentBrowsedContentItems() {
        ByJQuery selector = ByJQuery.selector((String)"table.browse-content tr");
        ArrayList<String> items = new ArrayList<String>();
        List webElements = this.getContentRoot().findElements((By)selector);
        items.addAll(webElements.stream().map(WebElement::getText).collect(Collectors.toList()));
        return items;
    }

    public void navigateToDeploymentAndInvokeView(String deploymentName) {
        if (ConfigUtils.isDomain()) {
            this.navigateToRowInServerGroup("main-server-group", deploymentName).invoke("View");
        } else {
            this.navigateToDeploymentInStandalone(deploymentName).invoke("View");
        }
        Application.waitUntilVisible();
    }

    public void disableEnabledDeployment(String deploymentName) {
        this.checkIfServerIsRunningInExpectedMode(ServerMode.STANDALONE);
        FinderNavigation navigation = new FinderNavigation(this.browser, StandaloneDeploymentEntryPoint.class);
        Row row = navigation.step("Deployment", deploymentName).selectRow();
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        row.invoke("Disable");
        Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirm();
    }

    public void enableDisabledDeployment(String deploymentName) {
        this.checkIfServerIsRunningInExpectedMode(ServerMode.STANDALONE);
        FinderNavigation navigation = new FinderNavigation(this.browser, StandaloneDeploymentEntryPoint.class);
        Row row = navigation.step("Deployment", deploymentName).selectRow();
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        row.invoke("Enable");
        Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirm();
    }

    private static enum ServerMode {
        STANDALONE,
        DOMAIN;

    }
}

