/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.testlistener;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.hal.testsuite.creaper.ManagementClientProvider;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.ReadAttributeOption;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public class ServerStateLoggerOperations {
    public Map<String, Map<String, String>> getServerStateMap() throws IOException {
        return this.tryWithClient(client -> {
            ModelReader reader = new ModelReader((OnlineManagementClient)client);
            return reader.getHostStream().collect(Collectors.toMap(Function.identity(), reader.getServerOfHostStatesFunction()));
        });
    }

    public boolean isReloadRequired() throws IOException {
        return this.tryWithClient(client -> new Administration(client).isReloadRequired());
    }

    public boolean isRestartRequired() throws IOException {
        return this.tryWithClient(client -> new Administration(client).isRestartRequired());
    }

    private <T> T tryWithClient(Function<OnlineManagementClient, T> modelReadFunction) throws IOException {
        try (OnlineManagementClient client = ManagementClientProvider.createOnlineManagementClient();){
            T t = modelReadFunction.apply(client);
            return t;
        }
    }

    private static class ModelReader {
        private final Operations ops;

        private ModelReader(OnlineManagementClient client) {
            this.ops = new Operations(client);
        }

        private Function<String, Map<String, String>> getServerOfHostStatesFunction() {
            return host -> this.getServerStream((String)host).collect(Collectors.toMap(Function.identity(), server -> this.readServerConfigStatus((String)host, (String)server)));
        }

        private Stream<String> getHostStream() {
            ModelNodeResult hostsResult = null;
            try {
                hostsResult = this.ops.readChildrenNames(Address.root(), "host");
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read hosts.", e);
            }
            hostsResult.assertDefinedValue();
            return hostsResult.stringListValue().stream();
        }

        private Stream<String> getServerStream(String host) {
            ModelNodeResult serversResult;
            try {
                serversResult = this.ops.readChildrenNames(Address.host((String)host), "server");
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read servers of host.", e);
            }
            serversResult.assertDefinedValue();
            return serversResult.stringListValue().stream();
        }

        private String readServerConfigStatus(String host, String server) {
            ModelNodeResult serverConfigStatusResult;
            try {
                serverConfigStatusResult = this.ops.readAttribute(Address.host((String)host).and("server-config", server), "status", new ReadAttributeOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read server config status.", e);
            }
            serverConfigStatusResult.assertDefinedValue();
            return serverConfigStatusResult.stringValue();
        }
    }
}

