/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.treefinder;

import java.util.LinkedList;
import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.hal.testsuite.treefinder.TreeNavigationGroup;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeNavigation {
    private static final Logger logger = LoggerFactory.getLogger(TreeNavigation.class);
    private static final String TREE_CLASS_NAME = "gwt-Tree";
    @Drone
    private WebDriver browser;
    @FindByJQuery(value=".gwt-Tree")
    @Root
    private WebElement root;
    private List<String> steps;

    private TreeNavigation() {
    }

    public TreeNavigation step(String label) {
        if (this.steps == null) {
            this.steps = new LinkedList<String>();
        }
        this.steps.add(label);
        return this;
    }

    public TreeNavigationGroup navigateToTreeItem() {
        TreeNavigationGroup current = new TreeNavigationGroup(this.root.findElement((By)ByJQuery.selector((String)"> div:nth-child(2)")));
        logger.trace("Top level {}: '{}'", (Object)TreeNavigationGroup.class.getSimpleName(), (Object)current.getRoot().getAttribute("innerHTML"));
        for (String step : this.steps) {
            logger.debug("Navigating to next subtree with root label '{}'.", (Object)step);
            current = current.openSubTreeIfNotOpen().getDirectChildByLabel(step);
        }
        return current;
    }
}

