/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.treefinder;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.openqa.selenium.By;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeNavigationGroup {
    private static final Logger logger = LoggerFactory.getLogger(TreeNavigationGroup.class);
    private static final String TREE_ITEM_CLASS_NAME = "gwt-TreeItem";
    private static final By DIRECT_CHILDREN_SELECTOR = ByJQuery.selector((String)"> div > div");
    private final WebElement root;

    TreeNavigationGroup(WebElement root) {
        this.root = root;
    }

    public WebElement getRoot() {
        return this.root;
    }

    private List<TreeNavigationGroup> getDirectChildren() {
        List elements = this.root.findElements(DIRECT_CHILDREN_SELECTOR);
        if (elements.size() > 0) {
            logger.debug("Found '{}' direct children!", (Object)elements.size());
            return elements.stream().map(TreeNavigationGroup::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String getLabel() {
        return this.root.findElement((By)ByJQuery.selector((String)"div.gwt-TreeItem")).getText().trim();
    }

    TreeNavigationGroup getDirectChildByLabel(String label) {
        for (TreeNavigationGroup child : this.getDirectChildren()) {
            if (!child.getLabel().equals(label)) continue;
            return child;
        }
        throw new NotFoundException("Not found child with label '" + label + "'!");
    }

    private TreeNavigationGroup clickOpenTreeToggleButton() {
        this.root.findElement((By)ByJQuery.selector((String)"> table tr > td > img")).click();
        return this;
    }

    public TreeNavigationGroup clickLabel() {
        this.root.findElement((By)ByJQuery.selector((String)"> table tr > td:has(div)")).click();
        return this;
    }

    TreeNavigationGroup openSubTreeIfNotOpen() {
        if (!this.root.findElement(DIRECT_CHILDREN_SELECTOR).isDisplayed()) {
            this.clickOpenTreeToggleButton();
        }
        return this;
    }

    public boolean hasSubtree() {
        return this.root.findElements((By)ByJQuery.selector((String)"> table")).size() > 0;
    }

    public boolean hasChildren() {
        return this.hasSubtree() && this.openSubTreeIfNotOpen().getDirectChildren().size() > 0;
    }

    public boolean hasChild(String label) {
        return this.hasChildren() && this.getDirectChildByLabel(label) != null;
    }
}

