/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.jboss.hal.testsuite.creaper.ResourceVerifier;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.formeditor.Editor;
import org.jboss.hal.testsuite.fragment.shared.modal.WizardWindow;
import org.junit.Assert;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;

public final class ConfigChecker {
    private final OnlineManagementClient client;
    private final Address resourceAddress;
    private boolean saved;

    public ResourceVerifier verifyFormSaved() throws Exception {
        return this.verifyFormSaved("");
    }

    public ResourceVerifier verifyFormSaved(String errorMessageSuffix) {
        Assert.assertTrue((String)("Configuration should switch into read-only mode! " + errorMessageSuffix), (boolean)this.saved);
        return new ResourceVerifier(this.resourceAddress, this.client);
    }

    public ResourceVerifier verifyFormNotSaved() throws Exception {
        return this.verifyFormNotSaved("");
    }

    public ResourceVerifier verifyFormNotSaved(String errorMessageSuffix) throws Exception {
        Assert.assertFalse((String)("Configuration should NOT switch into read-only mode. " + errorMessageSuffix), (boolean)this.saved);
        return new ResourceVerifier(this.resourceAddress, this.client);
    }

    private ConfigChecker(Builder builder) throws IOException, InterruptedException, TimeoutException {
        this.client = builder.client;
        this.resourceAddress = builder.resourceAddress;
        WizardWindow wizardWindow = builder.wizardWindow;
        Editor editor = builder.config.edit();
        for (Input input : builder.inputList) {
            this.enter(editor, input);
        }
        this.saved = wizardWindow != null ? wizardWindow.saveAndDismissReloadRequiredWindow() : builder.config.save();
        if (!this.saved && wizardWindow == null) {
            builder.config.cancel();
        }
    }

    private String getStringAttrValue(Input input) {
        switch (input.inputType) {
            case TEXT: 
            case SELECT: {
                if (input.attrValue instanceof String) {
                    return (String)input.attrValue;
                }
                if (input.attrValue instanceof Long) {
                    return String.valueOf((Long)input.attrValue);
                }
                if (input.attrValue instanceof Integer) {
                    return String.valueOf((Integer)input.attrValue);
                }
                throw new IllegalArgumentException(input.attrValue + " should be String, Integer or Long!");
            }
        }
        throw new IllegalArgumentException("Not supported inputType: " + (Object)((Object)input.inputType));
    }

    private boolean getBooleanAttrValue(Input input) {
        switch (input.inputType) {
            case CHECKBOX: {
                if (input.attrValue instanceof Boolean) {
                    return (Boolean)input.attrValue;
                }
                throw new IllegalArgumentException(input.attrValue + " should be Boolean!");
            }
        }
        throw new IllegalArgumentException("Not supported inputType: " + (Object)((Object)input.inputType));
    }

    private void enter(Editor editor, Input input) throws IOException, InterruptedException, TimeoutException {
        switch (input.inputType) {
            case TEXT: {
                String value = this.getStringAttrValue(input);
                switch (input.inputMethod) {
                    case HUMAN: {
                        editor.enterTextLikeHuman(input.identifier, value);
                        break;
                    }
                    case MACHINE: {
                        editor.text(input.identifier, this.getStringAttrValue(input));
                    }
                }
                break;
            }
            case CHECKBOX: {
                editor.checkbox(input.identifier, this.getBooleanAttrValue(input));
                break;
            }
            case SELECT: {
                editor.select(input.identifier, this.getStringAttrValue(input));
            }
        }
    }

    private static class Input {
        private InputType inputType;
        private String identifier;
        private Object attrValue;
        private InputMethod inputMethod;

        private Input(InputType inputType, String identifier, Object attrValue, InputMethod inputMethod) {
            this.inputType = inputType;
            this.identifier = identifier;
            this.attrValue = attrValue;
            this.inputMethod = inputMethod;
        }
    }

    public static enum InputMethod {
        MACHINE,
        HUMAN;

    }

    public static class Builder {
        private final OnlineManagementClient client;
        private final Address resourceAddress;
        private ConfigFragment config;
        private WizardWindow wizardWindow;
        private List<Input> inputList;

        public Builder(OnlineManagementClient client, Address resourceAddress) {
            this.client = client;
            this.resourceAddress = resourceAddress;
        }

        public Builder configFragment(ConfigFragment config) {
            this.config = config;
            return this;
        }

        public Builder wizardWindow(WizardWindow wizardWindow) {
            this.wizardWindow = wizardWindow;
            return this;
        }

        public Builder edit(InputType inputType, String identifier, Object attrValue) {
            return this.edit(inputType, identifier, attrValue, InputMethod.MACHINE);
        }

        public Builder edit(InputType inputType, String identifier, Object attrValue, InputMethod inputMethod) {
            if (this.inputList == null) {
                this.inputList = new ArrayList<Input>();
            }
            this.inputList.add(new Input(inputType, identifier, attrValue, inputMethod));
            return this;
        }

        public ConfigChecker andSave() throws IOException, InterruptedException, TimeoutException {
            if (this.config == null) {
                throw new IllegalStateException("ConfigFragment has to be set!");
            }
            if (this.inputList == null) {
                throw new IllegalStateException("Input has to be set!");
            }
            return new ConfigChecker(this);
        }

        public ConfigChecker editAndSave(InputType inputType, String identifier, Object attrValue) throws IOException, InterruptedException, TimeoutException {
            return this.edit(inputType, identifier, attrValue).andSave();
        }
    }

    public static enum InputType {
        TEXT,
        SELECT,
        CHECKBOX;

    }
}

