/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util;

import java.io.IOException;
import org.apache.commons.lang3.RandomStringUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.hal.testsuite.creaper.ResourceVerifier;
import org.jboss.hal.testsuite.dmr.ModelNodeGenerator;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.shared.modal.WizardWindow;
import org.jboss.hal.testsuite.util.ConfigChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.ReadAttributeOption;
import org.wildfly.extras.creaper.core.online.operations.Values;

public class ElytronIntegrationChecker {
    private static final Logger log = LoggerFactory.getLogger(ElytronIntegrationChecker.class);
    private static final String CREDENTIAL_REFERENCE = "credential-reference";
    private static final String CREDENTIAL_STORE = "credential-store";
    private static final String CLEAR_TEXT = "clear-text";
    private static final String SECRET_VALUE = "secret-value";
    private static final String ADD_ALIAS = "add-alias";
    private static final String ALIAS = "alias";
    private static final String STORE = "store";
    private static final String TYPE = "type";
    private final OnlineManagementClient client;
    private final Operations operations;
    private ConfigFragment configFragment;
    private WizardWindow wizardWindow;
    private Address address;
    private String credentialReferenceAttributeName;

    private ElytronIntegrationChecker(Builder builder) {
        this.client = builder.client;
        this.operations = new Operations(this.client);
        this.address = builder.address;
        this.configFragment = builder.configFragment;
        this.wizardWindow = builder.wizardWindow;
        this.credentialReferenceAttributeName = builder.credentialReferenceAttributeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClearTextCredentialReferenceAndVerify(String errorMessage) throws Exception {
        String clearTextValue = "clear-text-value_" + RandomStringUtils.randomAlphanumeric((int)6);
        ModelNodeResult originalValue = this.operations.readAttribute(this.address, this.credentialReferenceAttributeName, new ReadAttributeOption[0]);
        originalValue.assertSuccess();
        try {
            ResourceVerifier verifier = new ConfigChecker.Builder(this.client, this.address).configFragment(this.configFragment).wizardWindow(this.wizardWindow).edit(ConfigChecker.InputType.TEXT, ALIAS, "").edit(ConfigChecker.InputType.TEXT, CLEAR_TEXT, clearTextValue).edit(ConfigChecker.InputType.TEXT, STORE, "").edit(ConfigChecker.InputType.TEXT, TYPE, "").andSave().verifyFormSaved(errorMessage);
            CredentialStoreModelNodeBuilder builder = new CredentialStoreModelNodeBuilder().clearText(clearTextValue);
            try {
                verifier.verifyAttribute(this.credentialReferenceAttributeName, builder.build(), errorMessage);
            }
            catch (AssertionError e) {
                log.warn("Attribute has probably defined explicit undefined values, trying verifying with explicitlydefined undefined values! See https://issues.jboss.org/browse/HAL-1292.", (Throwable)((Object)e));
                verifier.verifyAttribute(this.credentialReferenceAttributeName, builder.writeUndefinedValuesExplicitly().build(), errorMessage);
            }
        }
        finally {
            this.operations.writeAttribute(this.address, this.credentialReferenceAttributeName, originalValue.value());
        }
    }

    public void setClearTextCredentialReferenceAndVerify() throws Exception {
        this.setClearTextCredentialReferenceAndVerify("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredentialStoreCredentialReferenceAndVerify(String errorMessage) throws Exception {
        String credentialStoreName = "credential-store_" + RandomStringUtils.randomAlphanumeric((int)6);
        String credentialStoreAliasName = "credential-store-alias_" + RandomStringUtils.randomAlphanumeric((int)6).toLowerCase();
        String credentialStoreAliasValue = "alias-value_" + RandomStringUtils.randomAlphanumeric((int)6);
        ModelNodeResult originalValue = this.operations.readAttribute(this.address, this.credentialReferenceAttributeName, new ReadAttributeOption[0]);
        originalValue.assertSuccess();
        Address credentialReferenceAddress = this.addCredentialStore(credentialStoreName);
        this.operations.invoke(ADD_ALIAS, credentialReferenceAddress, Values.empty().and(ALIAS, credentialStoreAliasValue).and(SECRET_VALUE, credentialStoreAliasValue)).assertSuccess();
        try {
            ResourceVerifier verifier = new ConfigChecker.Builder(this.client, this.address).configFragment(this.configFragment).wizardWindow(this.wizardWindow).edit(ConfigChecker.InputType.TEXT, ALIAS, credentialStoreAliasName, ConfigChecker.InputMethod.HUMAN).edit(ConfigChecker.InputType.TEXT, CLEAR_TEXT, "").edit(ConfigChecker.InputType.TEXT, STORE, credentialStoreName).edit(ConfigChecker.InputType.TEXT, TYPE, "").andSave().verifyFormSaved(errorMessage);
            CredentialStoreModelNodeBuilder builder = new CredentialStoreModelNodeBuilder().aliasName(credentialStoreAliasName).storeName(credentialStoreName);
            try {
                verifier.verifyAttribute(this.credentialReferenceAttributeName, builder.build(), errorMessage);
            }
            catch (AssertionError e) {
                log.warn("Attribute has probably defined explicit undefined values, trying verifying with explicitlydefined undefined values! See https://issues.jboss.org/browse/HAL-1292.", (Throwable)((Object)e));
                verifier.verifyAttribute(this.credentialReferenceAttributeName, builder.writeUndefinedValuesExplicitly().build(), errorMessage);
            }
        }
        finally {
            this.operations.writeAttribute(this.address, this.credentialReferenceAttributeName, originalValue.value());
            this.operations.removeIfExists(credentialReferenceAddress);
        }
    }

    public void setCredentialStoreCredentialReferenceAndVerify() throws Exception {
        this.setCredentialStoreCredentialReferenceAndVerify("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIllegalCombinationCredentialReferenceAttributes(String errorMessage) throws Exception {
        ModelNodeResult originalValue = this.operations.readAttribute(this.address, this.credentialReferenceAttributeName, new ReadAttributeOption[0]);
        originalValue.assertSuccess();
        String credentialStoreName = "credential-store-name_" + RandomStringUtils.randomAlphanumeric((int)6);
        Address credentialStoreAddress = this.addCredentialStore(credentialStoreName);
        try {
            new ConfigChecker.Builder(this.client, this.address).configFragment(this.configFragment).wizardWindow(this.wizardWindow).edit(ConfigChecker.InputType.TEXT, ALIAS, "").edit(ConfigChecker.InputType.TEXT, CLEAR_TEXT, RandomStringUtils.randomAlphanumeric((int)6)).edit(ConfigChecker.InputType.TEXT, STORE, credentialStoreName).edit(ConfigChecker.InputType.TEXT, TYPE, "").andSave().verifyFormNotSaved(errorMessage);
        }
        finally {
            this.operations.writeAttribute(this.address, this.credentialReferenceAttributeName, originalValue.value());
            this.operations.removeIfExists(credentialStoreAddress);
        }
    }

    public void testIllegalCombinationCredentialReferenceAttributes() throws Exception {
        this.testIllegalCombinationCredentialReferenceAttributes("");
    }

    private Address addCredentialStore(String credentialStoreName) throws IOException {
        Address credentialReferenceAddress = Address.subsystem((String)"elytron").and(CREDENTIAL_STORE, credentialStoreName);
        this.operations.add(credentialReferenceAddress, Values.of((String)"create", (boolean)true).and(CREDENTIAL_REFERENCE, new ModelNode().set(new Property(CLEAR_TEXT, new ModelNode("foobar"))).asObject())).assertSuccess();
        return credentialReferenceAddress;
    }

    public static final class Builder {
        private final OnlineManagementClient client;
        private String credentialReferenceAttributeName;
        private Address address;
        private ConfigFragment configFragment;
        private WizardWindow wizardWindow;

        public Builder(OnlineManagementClient client) {
            this.client = client;
        }

        public Builder credetialReferenceAttributeName(String credentialReferenceAttributeName) {
            this.credentialReferenceAttributeName = credentialReferenceAttributeName;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Builder configFragment(ConfigFragment configFragment) {
            this.configFragment = configFragment;
            return this;
        }

        public Builder wizardWindow(WizardWindow wizardWindow) {
            this.wizardWindow = wizardWindow;
            return this;
        }

        private void validate() {
            if (this.client == null) {
                throw new IllegalStateException("Client cannot be null!");
            }
            if (this.configFragment == null) {
                throw new IllegalStateException("Config fragment cannot be null!");
            }
            if (this.address == null) {
                throw new IllegalStateException("Address cannot be null!");
            }
            if (this.credentialReferenceAttributeName == null) {
                this.credentialReferenceAttributeName = ElytronIntegrationChecker.CREDENTIAL_REFERENCE;
            }
        }

        public ElytronIntegrationChecker build() {
            this.validate();
            return new ElytronIntegrationChecker(this);
        }
    }

    private static final class CredentialStoreModelNodeBuilder {
        private boolean writeUndefinedValuesExplicitly;
        private String clearText;
        private String storeName;
        private String aliasName;
        private String typeName;

        private CredentialStoreModelNodeBuilder() {
        }

        public CredentialStoreModelNodeBuilder writeUndefinedValuesExplicitly() {
            this.writeUndefinedValuesExplicitly = true;
            return this;
        }

        public CredentialStoreModelNodeBuilder clearText(String clearText) {
            this.clearText = clearText;
            return this;
        }

        public CredentialStoreModelNodeBuilder storeName(String storeName) {
            this.storeName = storeName;
            return this;
        }

        public CredentialStoreModelNodeBuilder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public CredentialStoreModelNodeBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public ModelNode build() {
            ModelNodeGenerator.ModelNodePropertiesBuilder builder = new ModelNodeGenerator.ModelNodePropertiesBuilder();
            if (this.aliasName != null) {
                builder.addProperty(ElytronIntegrationChecker.ALIAS, this.aliasName);
            } else if (this.writeUndefinedValuesExplicitly) {
                builder.addProperty(ElytronIntegrationChecker.ALIAS, new ModelNode());
            }
            if (this.clearText != null) {
                builder.addProperty(ElytronIntegrationChecker.CLEAR_TEXT, this.clearText);
            } else if (this.writeUndefinedValuesExplicitly) {
                builder.addProperty(ElytronIntegrationChecker.CLEAR_TEXT, new ModelNode());
            }
            if (this.storeName != null) {
                builder.addProperty(ElytronIntegrationChecker.STORE, this.storeName);
            } else if (this.writeUndefinedValuesExplicitly) {
                builder.addProperty(ElytronIntegrationChecker.STORE, new ModelNode());
            }
            if (this.typeName != null) {
                builder.addProperty(ElytronIntegrationChecker.TYPE, this.typeName);
            } else if (this.writeUndefinedValuesExplicitly) {
                builder.addProperty(ElytronIntegrationChecker.TYPE, new ModelNode());
            }
            return builder.build();
        }
    }
}

