/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.ReadResourceOption;

public class SuggestionResource {
    private final OnlineManagementClient client;
    private final List<Address> templates;

    private SuggestionResource(Builder builder) {
        this.client = builder.client;
        this.templates = builder.templates;
    }

    public List<String> readSuggestions() throws IOException {
        LinkedList<String> suggestions = new LinkedList<String>();
        for (Address template : this.templates) {
            this.readResource(template).get("result").asList().stream().filter(step -> step.get("address").isDefined()).map(step -> this.formatAddressName(step.get("address"))).forEachOrdered(suggestions::add);
        }
        return suggestions;
    }

    private ModelNodeResult readResource(Address template) throws IOException {
        return new Operations(this.client).readResource(template, new ReadResourceOption[0]);
    }

    private String formatAddressName(ModelNode address) {
        String EQUALS = " = ";
        String SLASH = " / ";
        StringBuilder stringBuilder = new StringBuilder();
        List addressParts = address.asList();
        for (int i = 0; i < addressParts.size(); ++i) {
            ModelNode addressPart = (ModelNode)addressParts.get(i);
            Property property = addressPart.asProperty();
            stringBuilder.append(property.getName()).append(" = ").append(property.getValue().asString());
            if (i + 1 >= addressParts.size()) continue;
            stringBuilder.append(" / ");
        }
        return stringBuilder.toString();
    }

    public static class Builder {
        private OnlineManagementClient client;
        private List<Address> templates;

        public Builder withClient(OnlineManagementClient client) {
            this.client = client;
            return this;
        }

        public Builder template(Address template) {
            if (this.templates == null) {
                this.templates = new LinkedList<Address>();
            }
            this.templates.add(template);
            return this;
        }

        private void validate() {
            if (this.client == null) {
                throw new IllegalArgumentException("Client is not defined!");
            }
            if (this.templates == null) {
                throw new IllegalArgumentException("No template is defined!");
            }
        }

        public SuggestionResource build() {
            this.validate();
            return new SuggestionResource(this);
        }
    }
}

