/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static Logger log = LoggerFactory.getLogger(ZipUtils.class);

    public static void updateOneFileInZip(File zip, File file, String fileName) throws IOException {
        log.info("Updating file {} using {} in zip archive {}", (Object[])new String[]{fileName, file.getAbsolutePath(), zip.getAbsolutePath()});
        Path filePath = file.toPath();
        try (FileSystem fileSystem = FileSystems.newFileSystem(zip.toPath(), null);){
            Path fileInsideZipPath = fileSystem.getPath(fileName, new String[0]);
            Files.copy(filePath, fileInsideZipPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new IOException("Unable to update " + fileName + " in " + zip.getAbsolutePath() + " using " + file.getAbsolutePath(), e);
        }
    }

    public static void extractOneFileFromZip(File zip, String fileName, File output) throws IOException {
        log.info("Extracting {} from {} to {}", (Object[])new String[]{fileName, zip.getAbsolutePath(), output.getAbsolutePath()});
        try (FileSystem fileSystem = FileSystems.newFileSystem(zip.toPath(), null);){
            Path source = fileSystem.getPath(fileName, new String[0]);
            Files.copy(source, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new IOException("Unable to extract " + fileName + " in " + zip.getAbsolutePath() + " into " + output.getAbsolutePath(), e);
        }
    }
}

