/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util;

import java.util.HashMap;
import java.util.Map;
import org.jboss.hal.testsuite.page.home.HomePage;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.RbacRole;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authentication {
    private static Map<WebDriver, Boolean> loginMap = new HashMap<WebDriver, Boolean>();
    private static final Logger log = LoggerFactory.getLogger(Console.class);
    private boolean authenticated = false;
    private WebDriver browser;

    public static Authentication with(WebDriver browser) {
        return new Authentication(browser);
    }

    private Authentication(WebDriver browser) {
        this.browser = browser;
        if (loginMap.containsKey(browser)) {
            this.authenticated = loginMap.get(browser);
        } else {
            loginMap.put(browser, this.authenticated);
        }
    }

    public void authenticate(String username, String password) {
        if (this.authenticated) {
            log.debug("# Already Logged in. Trying to Logout");
            this.logout();
        }
        log.debug("# Trying to authenticate using following credentials");
        log.debug("# username: " + username);
        log.debug("# password: " + password);
        String authUrl = "localhost:9990/management/";
        String protocol = "http";
        this.browser.get(protocol + "://" + username + ":" + password + "@" + authUrl);
        this.authenticated = true;
        loginMap.replace(this.browser, true);
        Console.withBrowser((WebDriver)this.browser).refreshAndNavigate(HomePage.class);
    }

    public void logout() {
        Console.withBrowser((WebDriver)this.browser).logout();
        this.authenticated = false;
        loginMap.replace(this.browser, false);
    }

    public void authenticate(RbacRole role) {
        this.authenticate(role.username, role.password);
    }
}

